/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.impl;

import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.KeyTransportAlgorithmPredicate;
import org.opensaml.xmlsec.encryption.support.RSAOAEPParameters;
import org.opensaml.xmlsec.impl.BasicEncryptionConfiguration;
import org.opensaml.xmlsec.keyinfo.NamedKeyInfoGeneratorManager;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class BasicEncryptionConfigurationTest {
    private BasicEncryptionConfiguration config;
    private Credential cred1;
    private Credential cred2;

    @BeforeClass
    public void generateCredentials() throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPair kp1 = KeySupport.generateKeyPair((String)"RSA", (int)2048, null);
        this.cred1 = CredentialSupport.getSimpleCredential((PublicKey)kp1.getPublic(), (PrivateKey)kp1.getPrivate());
        KeyPair kp2 = KeySupport.generateKeyPair((String)"RSA", (int)2048, null);
        this.cred2 = CredentialSupport.getSimpleCredential((PublicKey)kp2.getPublic(), (PrivateKey)kp2.getPrivate());
    }

    @BeforeMethod
    public void setUp() {
        this.config = new BasicEncryptionConfiguration();
    }

    @Test
    public void testDefaults() {
        Assert.assertNotNull((Object)this.config.getDataEncryptionCredentials());
        Assert.assertTrue((boolean)this.config.getDataEncryptionCredentials().isEmpty());
        Assert.assertNotNull((Object)this.config.getDataEncryptionAlgorithms());
        Assert.assertTrue((boolean)this.config.getDataEncryptionAlgorithms().isEmpty());
        Assert.assertNotNull((Object)this.config.getKeyTransportEncryptionCredentials());
        Assert.assertTrue((boolean)this.config.getKeyTransportEncryptionCredentials().isEmpty());
        Assert.assertNotNull((Object)this.config.getKeyTransportEncryptionAlgorithms());
        Assert.assertTrue((boolean)this.config.getKeyTransportEncryptionAlgorithms().isEmpty());
        Assert.assertNull((Object)this.config.getDataKeyInfoGeneratorManager());
        Assert.assertNull((Object)this.config.getKeyTransportKeyInfoGeneratorManager());
        Assert.assertNull((Object)this.config.getRSAOAEPParameters());
        Assert.assertNull((Object)this.config.getKeyTransportAlgorithmPredicate());
    }

    @Test
    public void testDataEncryptionCredentials() {
        Assert.assertNotNull((Object)this.config.getDataEncryptionCredentials());
        Assert.assertEquals((int)this.config.getDataEncryptionCredentials().size(), (int)0);
        this.config.setDataEncryptionCredentials(Arrays.asList(this.cred1, this.cred2));
        Assert.assertNotNull((Object)this.config.getDataEncryptionCredentials());
        Assert.assertEquals((int)this.config.getDataEncryptionCredentials().size(), (int)2);
        this.config.setDataEncryptionCredentials(null);
        Assert.assertNotNull((Object)this.config.getDataEncryptionCredentials());
        Assert.assertEquals((int)this.config.getDataEncryptionCredentials().size(), (int)0);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testDataEncryptionCredentialsImmutable() {
        this.config.setDataEncryptionCredentials(CollectionSupport.singletonList((Object)this.cred1));
        this.config.getDataEncryptionCredentials().add(this.cred2);
    }

    @Test
    public void testDataEncryptionAlgorithmURIs() {
        Assert.assertNotNull((Object)this.config.getDataEncryptionAlgorithms());
        Assert.assertEquals((int)this.config.getDataEncryptionAlgorithms().size(), (int)0);
        this.config.setDataEncryptionAlgorithms(CollectionSupport.listOf((Object[])new String[]{"   A   ", "   B    ", "   C    "}));
        Assert.assertNotNull((Object)this.config.getDataEncryptionAlgorithms());
        Assert.assertEquals((int)this.config.getDataEncryptionAlgorithms().size(), (int)3);
        Assert.assertEquals((String)((String)this.config.getDataEncryptionAlgorithms().get(0)), (String)"A");
        Assert.assertEquals((String)((String)this.config.getDataEncryptionAlgorithms().get(1)), (String)"B");
        Assert.assertEquals((String)((String)this.config.getDataEncryptionAlgorithms().get(2)), (String)"C");
        this.config.setDataEncryptionAlgorithms(null);
        Assert.assertNotNull((Object)this.config.getDataEncryptionAlgorithms());
        Assert.assertEquals((int)this.config.getDataEncryptionAlgorithms().size(), (int)0);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testDataEncryptionAlgorithmURIsImmutable() {
        this.config.setDataEncryptionAlgorithms(CollectionSupport.listOf((Object[])new String[]{"A", "B", "C"}));
        this.config.getDataEncryptionAlgorithms().add("D");
    }

    @Test
    public void testKeyTransportEncryptionCredentials() {
        Assert.assertNotNull((Object)this.config.getKeyTransportEncryptionCredentials());
        Assert.assertEquals((int)this.config.getKeyTransportEncryptionCredentials().size(), (int)0);
        this.config.setKeyTransportEncryptionCredentials(CollectionSupport.listOf((Object)this.cred1, (Object)this.cred2));
        Assert.assertNotNull((Object)this.config.getKeyTransportEncryptionCredentials());
        Assert.assertEquals((int)this.config.getKeyTransportEncryptionCredentials().size(), (int)2);
        this.config.setKeyTransportEncryptionCredentials(null);
        Assert.assertNotNull((Object)this.config.getKeyTransportEncryptionCredentials());
        Assert.assertEquals((int)this.config.getKeyTransportEncryptionCredentials().size(), (int)0);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testKeyTransportEncryptionCredentialsImmutable() {
        this.config.setKeyTransportEncryptionCredentials(CollectionSupport.singletonList((Object)this.cred1));
        this.config.getKeyTransportEncryptionCredentials().add(this.cred2);
    }

    @Test
    public void testKeyTransportEncryptionAlgorithmURIs() {
        Assert.assertNotNull((Object)this.config.getKeyTransportEncryptionAlgorithms());
        Assert.assertEquals((int)this.config.getKeyTransportEncryptionAlgorithms().size(), (int)0);
        this.config.setKeyTransportEncryptionAlgorithms(Arrays.asList("   A    ", null, null, "   B   ", null, "   C   "));
        Assert.assertNotNull((Object)this.config.getKeyTransportEncryptionAlgorithms());
        Assert.assertEquals((int)this.config.getKeyTransportEncryptionAlgorithms().size(), (int)3);
        Assert.assertEquals((String)((String)this.config.getKeyTransportEncryptionAlgorithms().get(0)), (String)"A");
        Assert.assertEquals((String)((String)this.config.getKeyTransportEncryptionAlgorithms().get(1)), (String)"B");
        Assert.assertEquals((String)((String)this.config.getKeyTransportEncryptionAlgorithms().get(2)), (String)"C");
        this.config.setKeyTransportEncryptionAlgorithms(null);
        Assert.assertNotNull((Object)this.config.getKeyTransportEncryptionAlgorithms());
        Assert.assertEquals((int)this.config.getKeyTransportEncryptionAlgorithms().size(), (int)0);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testKeyTransportEncryptionAlgorithmURIsImmutable() {
        this.config.setKeyTransportEncryptionAlgorithms(Arrays.asList("A", "B", "C"));
        this.config.getKeyTransportEncryptionAlgorithms().add("D");
    }

    @Test
    public void testDataKeyInfoGeneratorManager() {
        Assert.assertNull((Object)this.config.getDataKeyInfoGeneratorManager());
        this.config.setDataKeyInfoGeneratorManager(new NamedKeyInfoGeneratorManager());
        Assert.assertNotNull((Object)this.config.getDataKeyInfoGeneratorManager());
        this.config.setDataKeyInfoGeneratorManager(null);
        Assert.assertNull((Object)this.config.getDataKeyInfoGeneratorManager());
    }

    @Test
    public void testKeyTransportKeyInfoGeneratorManager() {
        Assert.assertNull((Object)this.config.getKeyTransportKeyInfoGeneratorManager());
        this.config.setKeyTransportKeyInfoGeneratorManager(new NamedKeyInfoGeneratorManager());
        Assert.assertNotNull((Object)this.config.getKeyTransportKeyInfoGeneratorManager());
        this.config.setKeyTransportKeyInfoGeneratorManager(null);
        Assert.assertNull((Object)this.config.getKeyTransportKeyInfoGeneratorManager());
    }

    @Test
    public void testRSAOAEPParameters() {
        Assert.assertNull((Object)this.config.getRSAOAEPParameters());
        this.config.setRSAOAEPParameters(new RSAOAEPParameters());
        Assert.assertNotNull((Object)this.config.getRSAOAEPParameters());
        this.config.setRSAOAEPParameters(null);
        Assert.assertNull((Object)this.config.getRSAOAEPParameters());
    }

    @Test
    public void testRSAOAEPParametersMerge() {
        Assert.assertTrue((boolean)this.config.isRSAOAEPParametersMerge());
        this.config.setRSAOAEPParametersMerge(false);
        Assert.assertFalse((boolean)this.config.isRSAOAEPParametersMerge());
        this.config.setRSAOAEPParametersMerge(true);
        Assert.assertTrue((boolean)this.config.isRSAOAEPParametersMerge());
    }

    @Test
    public void testKeyTransportAlgorithmPredicate() {
        Assert.assertNull((Object)this.config.getKeyTransportAlgorithmPredicate());
        KeyTransportAlgorithmPredicate predicate = new KeyTransportAlgorithmPredicate(){

            public boolean test(@Nullable KeyTransportAlgorithmPredicate.SelectionInput input) {
                return true;
            }
        };
        this.config.setKeyTransportAlgorithmPredicate(predicate);
        Assert.assertNotNull((Object)this.config.getKeyTransportAlgorithmPredicate());
        this.config.setKeyTransportAlgorithmPredicate(null);
        Assert.assertNull((Object)this.config.getKeyTransportAlgorithmPredicate());
    }
}

