/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.impl;

import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.crypto.SecretKey;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.criterion.KeyInfoGenerationProfileCriterion;
import org.opensaml.xmlsec.criterion.SignatureSigningConfigurationCriterion;
import org.opensaml.xmlsec.impl.BasicSignatureSigningConfiguration;
import org.opensaml.xmlsec.impl.BasicSignatureSigningParametersResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.keyinfo.NamedKeyInfoGeneratorManager;
import org.opensaml.xmlsec.keyinfo.impl.BasicKeyInfoGeneratorFactory;
import org.opensaml.xmlsec.keyinfo.impl.X509KeyInfoGeneratorFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class BasicSignatureSigningParametersResolverTest
extends XMLObjectBaseTestCase {
    private BasicSignatureSigningParametersResolver resolver;
    private CriteriaSet criteriaSet;
    private SignatureSigningConfigurationCriterion criterion;
    private BasicSignatureSigningConfiguration config1;
    private BasicSignatureSigningConfiguration config2;
    private BasicSignatureSigningConfiguration config3;
    private Credential rsaCred;
    private Credential dsaCred;
    private Credential ecCred;
    private Credential hmacCred;
    private String defaultReferenceDigest = "http://www.w3.org/2000/09/xmldsig#sha1";
    private String defaultC14N = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private String defaultRSAAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    private String defaultDSAAlgo = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    private String defaultECAlgo = "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1";
    private String defaultHMACAlgo = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    private Integer defaultHMACOutputLength = 128;
    private NamedKeyInfoGeneratorManager defaultKeyInfoGeneratorManager = new NamedKeyInfoGeneratorManager();

    @BeforeClass
    public void buildCredentials() throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPair rsaKeyPair = KeySupport.generateKeyPair((String)"RSA", (int)2048, null);
        this.rsaCred = CredentialSupport.getSimpleCredential((PublicKey)rsaKeyPair.getPublic(), (PrivateKey)rsaKeyPair.getPrivate());
        KeyPair dsaKeyPair = KeySupport.generateKeyPair((String)"DSA", (int)1024, null);
        this.dsaCred = CredentialSupport.getSimpleCredential((PublicKey)dsaKeyPair.getPublic(), (PrivateKey)dsaKeyPair.getPrivate());
        try {
            KeyPair ecKeyPair = KeySupport.generateKeyPair((String)"EC", (int)256, null);
            this.ecCred = CredentialSupport.getSimpleCredential((PublicKey)ecKeyPair.getPublic(), (PrivateKey)ecKeyPair.getPrivate());
        }
        catch (NoSuchAlgorithmException ecKeyPair) {
            // empty catch block
        }
        SecretKey hmacKey = KeySupport.generateKey((String)"AES", (int)128, null);
        this.hmacCred = CredentialSupport.getSimpleCredential((SecretKey)hmacKey);
    }

    @BeforeMethod
    public void setUp() {
        this.resolver = new BasicSignatureSigningParametersResolver();
        this.config1 = new BasicSignatureSigningConfiguration();
        this.config2 = new BasicSignatureSigningConfiguration();
        this.config3 = new BasicSignatureSigningConfiguration();
        this.config3.setSignatureAlgorithms(List.of(this.defaultRSAAlgo, this.defaultDSAAlgo, this.defaultECAlgo, this.defaultHMACAlgo));
        this.config3.setSignatureReferenceDigestMethods(CollectionSupport.singletonList((Object)this.defaultReferenceDigest));
        this.config3.setSignatureCanonicalizationAlgorithm(this.defaultC14N);
        this.config3.setSignatureHMACOutputLength(this.defaultHMACOutputLength);
        BasicKeyInfoGeneratorFactory basicFactory = new BasicKeyInfoGeneratorFactory();
        X509KeyInfoGeneratorFactory x509Factory = new X509KeyInfoGeneratorFactory();
        this.defaultKeyInfoGeneratorManager = new NamedKeyInfoGeneratorManager();
        this.defaultKeyInfoGeneratorManager.registerDefaultFactory((KeyInfoGeneratorFactory)basicFactory);
        this.defaultKeyInfoGeneratorManager.registerDefaultFactory((KeyInfoGeneratorFactory)x509Factory);
        this.config3.setKeyInfoGeneratorManager(this.defaultKeyInfoGeneratorManager);
        this.criterion = new SignatureSigningConfigurationCriterion(new SignatureSigningConfiguration[]{this.config1, this.config2, this.config3});
        this.criteriaSet = new CriteriaSet(new Criterion[]{this.criterion});
    }

    @Test
    public void testBasicRSA() throws ResolverException {
        this.config1.setSigningCredentials(CollectionSupport.singletonList((Object)this.rsaCred));
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteriaSet);
        assert (params != null);
        Assert.assertEquals((Object)params.getSigningCredential(), (Object)this.rsaCred);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)this.defaultRSAAlgo);
        Assert.assertEquals((String)params.getSignatureReferenceDigestMethod(), (String)this.defaultReferenceDigest);
        Assert.assertNull((Object)params.getSignatureReferenceCanonicalizationAlgorithm());
        Assert.assertEquals((String)params.getSignatureCanonicalizationAlgorithm(), (String)this.defaultC14N);
        Assert.assertNull((Object)params.getSignatureHMACOutputLength());
        Assert.assertNotNull((Object)params.getKeyInfoGenerator());
    }

    @Test
    public void testRSAWithAlgorithmOverride() throws ResolverException {
        this.config1.setSigningCredentials(CollectionSupport.singletonList((Object)this.rsaCred));
        this.config2.setSignatureAlgorithms(CollectionSupport.singletonList((Object)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"));
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteriaSet);
        assert (params != null);
        Assert.assertEquals((Object)params.getSigningCredential(), (Object)this.rsaCred);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        Assert.assertEquals((String)params.getSignatureReferenceDigestMethod(), (String)this.defaultReferenceDigest);
        Assert.assertNull((Object)params.getSignatureReferenceCanonicalizationAlgorithm());
        Assert.assertEquals((String)params.getSignatureCanonicalizationAlgorithm(), (String)this.defaultC14N);
        Assert.assertNull((Object)params.getSignatureHMACOutputLength());
        Assert.assertNotNull((Object)params.getKeyInfoGenerator());
    }

    @Test
    public void testRSAWithBlacklist() throws ResolverException {
        this.config1.setSigningCredentials(CollectionSupport.singletonList((Object)this.rsaCred));
        this.config1.setExcludedAlgorithms(List.of("http://www.w3.org/2000/09/xmldsig#rsa-sha1", "http://www.w3.org/2000/09/xmldsig#sha1"));
        this.config2.setSignatureAlgorithms(List.of("http://www.w3.org/2000/09/xmldsig#rsa-sha1", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"));
        this.config2.setSignatureReferenceDigestMethods(List.of("http://www.w3.org/2000/09/xmldsig#sha1", "http://www.w3.org/2001/04/xmlenc#sha256"));
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteriaSet);
        assert (params != null);
        Assert.assertEquals((Object)params.getSigningCredential(), (Object)this.rsaCred);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        Assert.assertEquals((String)params.getSignatureReferenceDigestMethod(), (String)"http://www.w3.org/2001/04/xmlenc#sha256");
        Assert.assertNull((Object)params.getSignatureReferenceCanonicalizationAlgorithm());
        Assert.assertEquals((String)params.getSignatureCanonicalizationAlgorithm(), (String)this.defaultC14N);
        Assert.assertNull((Object)params.getSignatureHMACOutputLength());
        Assert.assertNotNull((Object)params.getKeyInfoGenerator());
    }

    @Test
    public void testRSAWithWhitelist() throws ResolverException {
        this.config1.setSigningCredentials(CollectionSupport.singletonList((Object)this.rsaCred));
        this.config1.setIncludedAlgorithms(List.of("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", "http://www.w3.org/2001/04/xmlenc#sha256"));
        this.config2.setSignatureAlgorithms(List.of("http://www.w3.org/2000/09/xmldsig#rsa-sha1", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"));
        this.config2.setSignatureReferenceDigestMethods(List.of("http://www.w3.org/2000/09/xmldsig#sha1", "http://www.w3.org/2001/04/xmlenc#sha256"));
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteriaSet);
        assert (params != null);
        Assert.assertEquals((Object)params.getSigningCredential(), (Object)this.rsaCred);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        Assert.assertEquals((String)params.getSignatureReferenceDigestMethod(), (String)"http://www.w3.org/2001/04/xmlenc#sha256");
        Assert.assertNull((Object)params.getSignatureReferenceCanonicalizationAlgorithm());
        Assert.assertEquals((String)params.getSignatureCanonicalizationAlgorithm(), (String)this.defaultC14N);
        Assert.assertNull((Object)params.getSignatureHMACOutputLength());
        Assert.assertNotNull((Object)params.getKeyInfoGenerator());
    }

    @Test
    public void testBasicDSA() throws ResolverException {
        this.config1.setSigningCredentials(CollectionSupport.singletonList((Object)this.dsaCred));
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteriaSet);
        assert (params != null);
        Assert.assertEquals((Object)params.getSigningCredential(), (Object)this.dsaCred);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)this.defaultDSAAlgo);
        Assert.assertEquals((String)params.getSignatureReferenceDigestMethod(), (String)this.defaultReferenceDigest);
        Assert.assertNull((Object)params.getSignatureReferenceCanonicalizationAlgorithm());
        Assert.assertEquals((String)params.getSignatureCanonicalizationAlgorithm(), (String)this.defaultC14N);
        Assert.assertNull((Object)params.getSignatureHMACOutputLength());
        Assert.assertNotNull((Object)params.getKeyInfoGenerator());
    }

    @Test
    public void testBasicEC() throws ResolverException {
        if (this.ecCred != null) {
            this.config1.setSigningCredentials(CollectionSupport.singletonList((Object)this.ecCred));
            SignatureSigningParameters params = this.resolver.resolveSingle(this.criteriaSet);
            assert (params != null);
            Assert.assertEquals((Object)params.getSigningCredential(), (Object)this.ecCred);
            Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)this.defaultECAlgo);
            Assert.assertEquals((String)params.getSignatureReferenceDigestMethod(), (String)this.defaultReferenceDigest);
            Assert.assertNull((Object)params.getSignatureReferenceCanonicalizationAlgorithm());
            Assert.assertEquals((String)params.getSignatureCanonicalizationAlgorithm(), (String)this.defaultC14N);
            Assert.assertNull((Object)params.getSignatureHMACOutputLength());
            Assert.assertNotNull((Object)params.getKeyInfoGenerator());
        }
    }

    @Test
    public void testBasicHMAC() throws ResolverException {
        this.config1.setSigningCredentials(CollectionSupport.singletonList((Object)this.hmacCred));
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteriaSet);
        assert (params != null);
        Assert.assertEquals((Object)params.getSigningCredential(), (Object)this.hmacCred);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)this.defaultHMACAlgo);
        Assert.assertEquals((String)params.getSignatureReferenceDigestMethod(), (String)this.defaultReferenceDigest);
        Assert.assertNull((Object)params.getSignatureReferenceCanonicalizationAlgorithm());
        Assert.assertEquals((String)params.getSignatureCanonicalizationAlgorithm(), (String)this.defaultC14N);
        Assert.assertEquals((Integer)params.getSignatureHMACOutputLength(), (Integer)this.defaultHMACOutputLength);
        Assert.assertNotNull((Object)params.getKeyInfoGenerator());
    }

    @Test
    public void testHMACWithOverrides() throws ResolverException {
        this.config1.setSigningCredentials(CollectionSupport.singletonList((Object)this.hmacCred));
        this.config2.setSignatureAlgorithms(CollectionSupport.singletonList((Object)"http://www.w3.org/2001/04/xmldsig-more#hmac-sha256"));
        this.config2.setSignatureReferenceDigestMethods(CollectionSupport.singletonList((Object)"http://www.w3.org/2001/04/xmlenc#sha256"));
        this.config2.setSignatureHMACOutputLength(Integer.valueOf(160));
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteriaSet);
        assert (params != null);
        Assert.assertEquals((Object)params.getSigningCredential(), (Object)this.hmacCred);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)"http://www.w3.org/2001/04/xmldsig-more#hmac-sha256");
        Assert.assertEquals((String)params.getSignatureReferenceDigestMethod(), (String)"http://www.w3.org/2001/04/xmlenc#sha256");
        Assert.assertEquals((String)params.getSignatureCanonicalizationAlgorithm(), (String)this.defaultC14N);
        Assert.assertNull((Object)params.getSignatureReferenceCanonicalizationAlgorithm());
        Assert.assertEquals((Integer)params.getSignatureHMACOutputLength(), (Integer)160);
        Assert.assertNotNull((Object)params.getKeyInfoGenerator());
    }

    @Test
    public void testC14NOverride() throws ResolverException {
        this.config1.setSigningCredentials(CollectionSupport.singletonList((Object)this.rsaCred));
        this.config2.setSignatureCanonicalizationAlgorithm("http://www.w3.org/2006/12/xml-c14n11#WithComments");
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteriaSet);
        assert (params != null);
        Assert.assertEquals((Object)params.getSigningCredential(), (Object)this.rsaCred);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)this.defaultRSAAlgo);
        Assert.assertEquals((String)params.getSignatureReferenceDigestMethod(), (String)this.defaultReferenceDigest);
        Assert.assertEquals((String)params.getSignatureCanonicalizationAlgorithm(), (String)"http://www.w3.org/2006/12/xml-c14n11#WithComments");
        Assert.assertNull((Object)params.getSignatureReferenceCanonicalizationAlgorithm());
        Assert.assertNull((Object)params.getSignatureHMACOutputLength());
        Assert.assertNotNull((Object)params.getKeyInfoGenerator());
    }

    @Test
    public void testReferenceC14NOverride() throws ResolverException {
        this.config1.setSigningCredentials(CollectionSupport.singletonList((Object)this.rsaCred));
        this.config2.setSignatureReferenceCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteriaSet);
        assert (params != null);
        Assert.assertEquals((Object)params.getSigningCredential(), (Object)this.rsaCred);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)this.defaultRSAAlgo);
        Assert.assertEquals((String)params.getSignatureReferenceDigestMethod(), (String)this.defaultReferenceDigest);
        Assert.assertEquals((String)params.getSignatureReferenceCanonicalizationAlgorithm(), (String)"http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        Assert.assertEquals((String)params.getSignatureCanonicalizationAlgorithm(), (String)this.defaultC14N);
        Assert.assertNull((Object)params.getSignatureHMACOutputLength());
        Assert.assertNotNull((Object)params.getKeyInfoGenerator());
    }

    @Test
    public void testMultipleCreds() throws ResolverException {
        this.config1.setSigningCredentials(List.of(this.rsaCred, this.dsaCred));
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteriaSet);
        assert (params != null);
        Assert.assertEquals((Object)params.getSigningCredential(), (Object)this.rsaCred);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)this.defaultRSAAlgo);
        Assert.assertEquals((String)params.getSignatureReferenceDigestMethod(), (String)this.defaultReferenceDigest);
        Assert.assertEquals((String)params.getSignatureCanonicalizationAlgorithm(), (String)this.defaultC14N);
        Assert.assertNull((Object)params.getSignatureReferenceCanonicalizationAlgorithm());
        Assert.assertNull((Object)params.getSignatureHMACOutputLength());
        Assert.assertNotNull((Object)params.getKeyInfoGenerator());
        this.config1.setSigningCredentials(List.of(this.dsaCred, this.rsaCred));
        params = this.resolver.resolveSingle(this.criteriaSet);
        assert (params != null);
        Assert.assertEquals((Object)params.getSigningCredential(), (Object)this.dsaCred);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)this.defaultDSAAlgo);
        Assert.assertEquals((String)params.getSignatureReferenceDigestMethod(), (String)this.defaultReferenceDigest);
        Assert.assertNull((Object)params.getSignatureReferenceCanonicalizationAlgorithm());
        Assert.assertEquals((String)params.getSignatureCanonicalizationAlgorithm(), (String)this.defaultC14N);
        Assert.assertNull((Object)params.getSignatureHMACOutputLength());
        Assert.assertNotNull((Object)params.getKeyInfoGenerator());
        if (this.ecCred != null) {
            this.config1.setSigningCredentials(List.of(this.ecCred, this.dsaCred, this.rsaCred));
            params = this.resolver.resolveSingle(this.criteriaSet);
            assert (params != null);
            Assert.assertEquals((Object)params.getSigningCredential(), (Object)this.ecCred);
            Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)this.defaultECAlgo);
            Assert.assertEquals((String)params.getSignatureReferenceDigestMethod(), (String)this.defaultReferenceDigest);
            Assert.assertNull((Object)params.getSignatureReferenceCanonicalizationAlgorithm());
            Assert.assertEquals((String)params.getSignatureCanonicalizationAlgorithm(), (String)this.defaultC14N);
            Assert.assertNull((Object)params.getSignatureHMACOutputLength());
            Assert.assertNotNull((Object)params.getKeyInfoGenerator());
        }
        this.config1.setSigningCredentials(List.of(this.hmacCred, this.dsaCred, this.rsaCred));
        params = this.resolver.resolveSingle(this.criteriaSet);
        assert (params != null);
        Assert.assertEquals((Object)params.getSigningCredential(), (Object)this.hmacCred);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)this.defaultHMACAlgo);
        Assert.assertEquals((String)params.getSignatureReferenceDigestMethod(), (String)this.defaultReferenceDigest);
        Assert.assertNull((Object)params.getSignatureReferenceCanonicalizationAlgorithm());
        Assert.assertEquals((String)params.getSignatureCanonicalizationAlgorithm(), (String)this.defaultC14N);
        Assert.assertEquals((Integer)params.getSignatureHMACOutputLength(), (Integer)this.defaultHMACOutputLength);
        Assert.assertNotNull((Object)params.getKeyInfoGenerator());
    }

    @Test
    public void testCredOverrides() throws ResolverException {
        this.config1.setSigningCredentials(CollectionSupport.singletonList((Object)this.dsaCred));
        this.config2.setSigningCredentials(List.of(this.rsaCred, this.dsaCred, this.hmacCred));
        this.config2.setSignatureAlgorithms(CollectionSupport.singletonList((Object)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"));
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteriaSet);
        assert (params != null);
        Assert.assertEquals((Object)params.getSigningCredential(), (Object)this.dsaCred);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)this.defaultDSAAlgo);
        Assert.assertEquals((String)params.getSignatureReferenceDigestMethod(), (String)this.defaultReferenceDigest);
        Assert.assertNull((Object)params.getSignatureReferenceCanonicalizationAlgorithm());
        Assert.assertEquals((String)params.getSignatureCanonicalizationAlgorithm(), (String)this.defaultC14N);
        Assert.assertNull((Object)params.getSignatureHMACOutputLength());
        Assert.assertNotNull((Object)params.getKeyInfoGenerator());
    }

    @Test
    public void testKeyInfoGenerationProfile() throws ResolverException {
        this.config1.setSigningCredentials(CollectionSupport.singletonList((Object)this.rsaCred));
        this.criteriaSet.add((Object)new KeyInfoGenerationProfileCriterion("testKeyInfoProfile"));
        this.defaultKeyInfoGeneratorManager.setUseDefaultManager(true);
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteriaSet);
        assert (params != null);
        Assert.assertNotNull((Object)params.getKeyInfoGenerator());
        this.defaultKeyInfoGeneratorManager.setUseDefaultManager(false);
        params = this.resolver.resolveSingle(this.criteriaSet);
        assert (params != null);
        Assert.assertNull((Object)params.getKeyInfoGenerator());
        this.defaultKeyInfoGeneratorManager.setUseDefaultManager(false);
        this.defaultKeyInfoGeneratorManager.registerFactory("testKeyInfoProfile", (KeyInfoGeneratorFactory)new BasicKeyInfoGeneratorFactory());
        params = this.resolver.resolveSingle(this.criteriaSet);
        assert (params != null);
        Assert.assertNotNull((Object)params.getKeyInfoGenerator());
    }

    @Test
    public void testResolve() throws ResolverException {
        this.config1.setSigningCredentials(CollectionSupport.singletonList((Object)this.rsaCred));
        Iterable paramsIter = this.resolver.resolve(this.criteriaSet);
        Assert.assertNotNull((Object)paramsIter);
        Iterator iterator = paramsIter.iterator();
        Assert.assertNotNull(iterator);
        Assert.assertTrue((boolean)iterator.hasNext());
        SignatureSigningParameters params = (SignatureSigningParameters)iterator.next();
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)params.getSigningCredential(), (Object)this.rsaCred);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)this.defaultRSAAlgo);
        Assert.assertEquals((String)params.getSignatureReferenceDigestMethod(), (String)this.defaultReferenceDigest);
        Assert.assertEquals((String)params.getSignatureCanonicalizationAlgorithm(), (String)this.defaultC14N);
        Assert.assertNull((Object)params.getSignatureHMACOutputLength());
        Assert.assertNotNull((Object)params.getKeyInfoGenerator());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testNoCredentials() throws ResolverException {
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNull((Object)params);
    }

    @Test
    public void testNoAlgorithms() throws ResolverException {
        this.config1.setSigningCredentials(CollectionSupport.singletonList((Object)this.rsaCred));
        this.config3.setSignatureAlgorithms(new ArrayList());
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNull((Object)params);
    }

    @Test
    public void testNoReferenceDigestMethods() throws ResolverException {
        this.config1.setSigningCredentials(CollectionSupport.singletonList((Object)this.rsaCred));
        this.config3.setSignatureReferenceDigestMethods(new ArrayList());
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNull((Object)params);
    }

    @Test
    public void testNoC14NAlgorithm() throws ResolverException {
        this.config1.setSigningCredentials(CollectionSupport.singletonList((Object)this.rsaCred));
        this.config3.setSignatureCanonicalizationAlgorithm(null);
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNull((Object)params);
    }

    @Test
    public void testNullCriteriaSet() throws ResolverException {
        Assert.assertNull((Object)this.resolver.resolveSingle(null));
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testAbsentCriterion() throws ResolverException {
        this.resolver.resolve(new CriteriaSet());
    }
}

