/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.impl.provider;

import java.io.IOException;
import java.io.InputStream;
import org.apache.xml.security.parser.XMLParserException;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.xmlsec.impl.provider.ApacheSantuarioXMLParser;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class ApacheSantuarioXMLParserTest
extends XMLObjectBaseTestCase {
    private ApacheSantuarioXMLParser parser;

    @BeforeClass
    public void setUpClass() throws InitializationException {
        this.parser = new ApacheSantuarioXMLParser();
    }

    @Test
    public void success() throws XMLParserException, IOException {
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/org/opensaml/xmlsec/signature/support/envelopedSignature.xml");){
            Document document = this.parser.parse(is, true);
            Assert.assertNotNull((Object)document);
        }
    }

    @Test(expectedExceptions={XMLParserException.class})
    public void failOnInvalidDisallowDocTypeDeclarations() throws XMLParserException, IOException {
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/org/opensaml/xmlsec/signature/support/envelopedSignature.xml");){
            this.parser.parse(is, false);
        }
    }

    @Test(expectedExceptions={XMLParserException.class})
    public void failOnInvalidXML() throws XMLParserException, IOException {
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/org/opensaml/xmlsec/impl/NotXML.txt");){
            this.parser.parse(is, true);
        }
    }
}

