/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.keyinfo.impl;

import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.util.ArrayList;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.impl.CollectionCredentialResolver;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolutionMode;
import org.opensaml.xmlsec.keyinfo.KeyInfoCriterion;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.keyinfo.impl.LocalKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.provider.RSAKeyValueProvider;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class LocalKeyInfoCredentialResolverTest
extends XMLObjectBaseTestCase {
    private String keyName;
    private KeyPair keyPair;
    private BasicCredential localCred;
    private CollectionCredentialResolver localCredResolver;
    private LocalKeyInfoCredentialResolver keyInfoResolver;
    private KeyInfo keyInfo;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.keyName = "MyKey";
        this.keyPair = KeySupport.generateKeyPair((String)"RSA", (int)1024, null);
        this.localCred = new BasicCredential(this.keyPair.getPublic(), this.keyPair.getPrivate());
        this.localCred.getKeyNames().add(this.keyName);
        this.localCredResolver = new CollectionCredentialResolver();
        this.localCredResolver.getCollection().add(this.localCred);
        ArrayList<RSAKeyValueProvider> providers = new ArrayList<RSAKeyValueProvider>();
        providers.add(new RSAKeyValueProvider());
        this.keyInfoResolver = new LocalKeyInfoCredentialResolver(providers, (CredentialResolver)this.localCredResolver);
        this.keyInfo = (KeyInfo)this.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
    }

    @Test
    public void testKeyInfoWithKeyName() throws ResolverException {
        KeyInfoSupport.addKeyName((KeyInfo)this.keyInfo, (String)this.keyName);
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new KeyInfoCriterion(this.keyInfo)});
        Credential resolvedCred = this.keyInfoResolver.resolveSingle(criteriaSet);
        Assert.assertEquals((Object)resolvedCred, (Object)this.localCred, (String)"Unexpected local credential resolved");
    }

    @Test
    public void testKeyInfoWithKnownPublicKey() throws ResolverException, EncodingException {
        KeyInfoSupport.addPublicKey((KeyInfo)this.keyInfo, (PublicKey)this.keyPair.getPublic());
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new KeyInfoCriterion(this.keyInfo)});
        Credential resolvedCred = this.keyInfoResolver.resolveSingle(criteriaSet);
        Assert.assertEquals((Object)resolvedCred, (Object)this.localCred, (String)"Unexpected local credential resolved");
    }

    @Test
    public void testKeyInfoWithUnknownPublicKey() throws IllegalArgumentException, NoSuchAlgorithmException, NoSuchProviderException, ResolverException, EncodingException {
        KeyInfoSupport.addPublicKey((KeyInfo)this.keyInfo, (PublicKey)KeySupport.generateKeyPair((String)"RSA", (int)1024, null).getPublic());
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new KeyInfoCriterion(this.keyInfo)});
        Credential resolvedCred = this.keyInfoResolver.resolveSingle(criteriaSet);
        Assert.assertNull((Object)resolvedCred, (String)"Expected no credential to be resolved");
    }

    @Test
    public void testLocalMode() throws ResolverException, EncodingException {
        KeyInfoSupport.addPublicKey((KeyInfo)this.keyInfo, (PublicKey)this.keyPair.getPublic());
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new KeyInfoCriterion(this.keyInfo), new KeyInfoCredentialResolutionMode(KeyInfoCredentialResolutionMode.Mode.LOCAL)});
        Credential resolvedCred = this.keyInfoResolver.resolveSingle(criteriaSet);
        Assert.assertEquals((Object)resolvedCred, (Object)this.localCred, (String)"Unexpected local credential resolved");
    }

    @Test
    public void testPublicMode() throws ResolverException, EncodingException {
        this.localCredResolver.getCollection().clear();
        KeyInfoSupport.addPublicKey((KeyInfo)this.keyInfo, (PublicKey)this.keyPair.getPublic());
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new KeyInfoCriterion(this.keyInfo), new KeyInfoCredentialResolutionMode(KeyInfoCredentialResolutionMode.Mode.PUBLIC)});
        Credential resolvedCred = this.keyInfoResolver.resolveSingle(criteriaSet);
        assert (resolvedCred != null);
        Assert.assertNotSame((Object)resolvedCred, (Object)this.localCred);
        Assert.assertNull((Object)resolvedCred.getPrivateKey());
        Assert.assertNotNull((Object)resolvedCred.getPublicKey());
        Assert.assertEquals((Object)resolvedCred.getPublicKey(), (Object)this.keyPair.getPublic());
    }

    @Test
    public void testBothModeWithLocalNotPresent() throws ResolverException, EncodingException {
        this.localCredResolver.getCollection().clear();
        KeyInfoSupport.addPublicKey((KeyInfo)this.keyInfo, (PublicKey)this.keyPair.getPublic());
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new KeyInfoCriterion(this.keyInfo), new KeyInfoCredentialResolutionMode(KeyInfoCredentialResolutionMode.Mode.BOTH)});
        Credential resolvedCred = this.keyInfoResolver.resolveSingle(criteriaSet);
        assert (resolvedCred != null);
        Assert.assertNotSame((Object)resolvedCred, (Object)this.localCred);
        Assert.assertNull((Object)resolvedCred.getPrivateKey());
        Assert.assertNotNull((Object)resolvedCred.getPublicKey());
        Assert.assertEquals((Object)resolvedCred.getPublicKey(), (Object)this.keyPair.getPublic());
    }

    @Test
    public void testBothModeWithLocalPresent() throws ResolverException, EncodingException {
        KeyInfoSupport.addPublicKey((KeyInfo)this.keyInfo, (PublicKey)this.keyPair.getPublic());
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new KeyInfoCriterion(this.keyInfo), new KeyInfoCredentialResolutionMode(KeyInfoCredentialResolutionMode.Mode.BOTH)});
        Credential resolvedCred = this.keyInfoResolver.resolveSingle(criteriaSet);
        Assert.assertEquals((Object)resolvedCred, (Object)this.localCred, (String)"Unexpected local credential resolved");
    }
}

