/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.keyinfo.impl;

import java.math.BigInteger;
import java.security.KeyException;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.security.auth.x500.X500Principal;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.DecodingException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.X509Support;
import org.opensaml.xmlsec.encryption.OriginatorKeyInfo;
import org.opensaml.xmlsec.encryption.RecipientKeyInfo;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.keyinfo.impl.X509KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.KeyValue;
import org.opensaml.xmlsec.signature.X509Data;
import org.opensaml.xmlsec.signature.X509Digest;
import org.opensaml.xmlsec.signature.X509IssuerName;
import org.opensaml.xmlsec.signature.X509IssuerSerial;
import org.opensaml.xmlsec.signature.X509SKI;
import org.opensaml.xmlsec.signature.X509SerialNumber;
import org.opensaml.xmlsec.signature.X509SubjectName;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class X509KeyInfoGeneratorTest
extends XMLObjectBaseTestCase {
    private static String subjectAltNameExtensionOID = "2.5.29.17";
    private BasicX509Credential credential;
    private X509KeyInfoGeneratorFactory factory;
    private KeyInfoGenerator generator;
    private String keyNameFoo = "FOO";
    private String keyNameBar = "BAR";
    private String entityID = "someEntityID";
    private PublicKey pubKey;
    private X509Certificate entityCert;
    private String entityCertBase64 = "MIIDzjCCAragAwIBAgIBMTANBgkqhkiG9w0BAQUFADAtMRIwEAYDVQQKEwlJbnRlcm5ldDIxFzAVBgNVBAMTDmNhLmV4YW1wbGUub3JnMB4XDTA3MDUyMTE4MjM0MFoXDTE3MDUxODE4MjM0MFowMTESMBAGA1UEChMJSW50ZXJuZXQyMRswGQYDVQQDExJmb29iYXIuZXhhbXBsZS5vcmcwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDNWnkFmhy1vYa6gN/xBRKkZxFy3sUq2V0LsYb6Q3pe9Qlb6+BzaM5DrN8uIqqroBE3Wp0LtrgKuQTpDpNFBdS2p5afiUtOYLWBDtizTOzs3Z36MGMjIPUYQ4s03IP3yPh2ud6EKpDPiYqzNbkRaiIwmYSit5r+RMYvd6fuKvTOn6h7PZI5AD7Rda7VWh5OVSoZXlRx3qxFho+mZhW0q4fUfTi5lWwf4EhkfBlzgw/k5gf4cOi6rrGpRS1zxmbtX1RAg+I20z6d04g0N2WsK5stszgYKoIROJCiXwjraa8/SoFcILolWQpttVHBIUYlyDlm8mIFleZf4ReFpfm+nUYxAgMBAAGjgfQwgfEwCQYDVR0TBAIwADAsBglghkgBhvhCAQ0EHxYdT3BlblNTTCBHZW5lcmF0ZWQgQ2VydGlmaWNhdGUwHQYDVR0OBBYEFDgRgTkjaKoK6DoZfUZ4g9LDJUWuMFUGA1UdIwROMEyAFNXuZVPeUdqHrULqQW7yr9buRpQLoTGkLzAtMRIwEAYDVQQKEwlJbnRlcm5ldDIxFzAVBgNVBAMTDmNhLmV4YW1wbGUub3JnggEBMEAGA1UdEQQ5MDeCEmFzaW1vdi5leGFtcGxlLm9yZ4YbaHR0cDovL2hlaW5sZWluLmV4YW1wbGUub3JnhwQKAQIDMA0GCSqGSIb3DQEBBQUAA4IBAQBLiDMyQ60ldIytVO1GCpp1S1sKJyTF56GVxHh/82hiRFbyPu+2eSl7UcJfH4ZNbAfHL1vDKTRJ9zoD8WRzpOCUtT0IPIA/Ex+8lFzZmujO10j3TMpp8Ii6+auYwi/Tosrfw1YCxF+GI5KO49CfDRr6yxUbMhbTN+ssK4UzFf36UbkeJ3EfDwB0WU70jnlkyO8f97X6mLd5QvRcwlkDMftP4+MB+inTlxDZ/w8NLXQoDW6p/8r91bupXe0xwuyEvow2xjxlzVcux2BZsUZYjBa07ZmNNBtF7WaQqH7l2OBCAdnBhvme5i/e0LK3Ivys+hcVyvCXs5XtFTFWDAVYvzQ6";
    private String entityCertSKIBase64 = "OBGBOSNoqgroOhl9RniD0sMlRa4=";
    private String entityCertDigestBase64 = "w+E2z13/aCCFAQWscM4BaH8U4M4=";
    private X509Certificate caCert;
    private String caCertBase64 = "MIIDXTCCAkWgAwIBAgIBATANBgkqhkiG9w0BAQUFADAtMRIwEAYDVQQKEwlJbnRlcm5ldDIxFzAVBgNVBAMTDmNhLmV4YW1wbGUub3JnMB4XDTA3MDQwOTA1NDcxMloXDTE3MDQwNjA1NDcxMlowLTESMBAGA1UEChMJSW50ZXJuZXQyMRcwFQYDVQQDEw5jYS5leGFtcGxlLm9yZzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBANxM5/6mBCcX+S7HApcKtfqdFRZzi6Ra91nkEzXOUcO+BPUdYqSxKGnCCso25ZOZP3gnJVkY8Pi7VWrCM6wRgIMyQDvNYqCpNjkZGFkrMoa6fm8BSaDHJ1fz6l/eEl0CVU3UuUAf0mXQLGm6Jannq8aMolRujlhE5iRaOJ2qp6wqsvyatK+vTgDngnwYVa4Cqu0jUeNF28quST5D3gIuZ0OeFHSM2Z1WUKkwwsHqVkxBBcH1QE1JOGIoSnrxxl/o4VlLWGEI8zq5qixE8VYtBBmijBwIL5ETy2fwiqcsvimQaQAtAfbtpO3kBSs8n7nnzMUHfRlcebGkwwcNfYcD5hcCAwEAAaOBhzCBhDAdBgNVHQ4EFgQU1e5lU95R2oetQupBbvKv1u5GlAswVQYDVR0jBE4wTIAU1e5lU95R2oetQupBbvKv1u5GlAuhMaQvMC0xEjAQBgNVBAoTCUludGVybmV0MjEXMBUGA1UEAxMOY2EuZXhhbXBsZS5vcmeCAQEwDAYDVR0TBAUwAwEB/zANBgkqhkiG9w0BAQUFAAOCAQEAbqrozetM/iBVIUir9k14HbLEP0lZ6jOPWFIUFXMOn0t8+Ul7PMp9Rdn+7OGQIoJw97/mam3kpQ/HmjJMFYv6MGsDQ4vAOiQiaTKzgMhrnCdVpVH9uz4ARHiysCujnjH9sehTWgybY8pXzzSG5BAjEGowHq01nXxq2K4yAJSdAUBYLfuSKW1uRU6cmEa9uzl9EvoZfAF3BLnGlPqu4ZajH2NC9ZY0y19LX4yeJLHL1sY4fyxb3x8QhcCXiI16awBTr/VnUpJjSe9vh+OudWGeyCL/KhjlrDkjJ3hIxBF5mP/Y27cFpRnC2gECkieURvh52OyuqkzpbOrTN5rD9fNinA==";
    private String subjectCN;
    private X500Principal subjectName;
    private X500Principal issuerName;
    private BigInteger serialNumber;
    private byte[] subjectKeyIdentifier;
    private byte[] x509Digest;
    private String altName1;
    private String altName2;
    private String altName3;
    private Integer altName1Type;
    private Integer altName2Type;
    private Integer altName3Type;
    private X509CRL caCRL;
    private String caCRLBase64 = "MIIBmjCBgwIBATANBgkqhkiG9w0BAQUFADAtMRIwEAYDVQQKEwlJbnRlcm5ldDIxFzAVBgNVBAMTDmNhLmV4YW1wbGUub3JnFw0wNzA1MjEwNTAwMzNaFw0wNzA2MjAwNTAwMzNaMCIwIAIBKxcNMDcwNTIxMDQ1ODI5WjAMMAoGA1UdFQQDCgEBMA0GCSqGSIb3DQEBBQUAA4IBAQAghL5eW9NsMRCk84mAZ+QMjoCuy7zZJr5vPHk7WrOffL7BGWZ6u6D1cSCzZNvrBolip1yb8KSdB9PJqEV1kInXnZegeqjENq+9j8nGdyoYuofhA5AU8L9n9fjwYTUkfNfAMWeVVuplJN4yAp03JSJULVqmC63EEP7u7kFS94Mze9sa+VqBu7tGyZ55XX8AO39d1c3DoHIPfS1wHHLyuWxnys8GjANJxQiZmFtUfPztp3qH/XlfFLgY5EBTanyOk5yycU/l+6P1RBhJZDPicp3iWVsjYHYWS+ovdyWuL7RrLRMbzecnCa5eIhSevoMYUkg4h9ckAZUQeHsK08gB/dFh";

    @BeforeMethod
    protected void setUp() throws Exception {
        this.factory = new X509KeyInfoGeneratorFactory();
        this.generator = null;
        this.entityCert = X509Support.decodeCertificate((String)this.entityCertBase64);
        this.pubKey = this.entityCert.getPublicKey();
        this.caCert = X509Support.decodeCertificate((String)this.caCertBase64);
        this.caCRL = X509Support.decodeCRL((String)this.caCRLBase64);
        this.subjectCN = "foobar.example.org";
        this.subjectName = new X500Principal("cn=foobar.example.org, O=Internet2");
        this.issuerName = new X500Principal("cn=ca.example.org, O=Internet2");
        this.serialNumber = new BigInteger("49");
        this.subjectKeyIdentifier = Base64Support.decode((String)this.entityCertSKIBase64);
        this.x509Digest = Base64Support.decode((String)this.entityCertDigestBase64);
        this.altName1 = "asimov.example.org";
        this.altName1Type = X509Support.DNS_ALT_NAME;
        this.altName2 = "http://heinlein.example.org";
        this.altName2Type = X509Support.URI_ALT_NAME;
        this.altName3 = "10.1.2.3";
        this.altName3Type = X509Support.IP_ADDRESS_ALT_NAME;
        this.credential = new BasicX509Credential(this.entityCert);
        this.credential.setEntityId(this.entityID);
        this.credential.getKeyNames().add(this.keyNameFoo);
        this.credential.getKeyNames().add(this.keyNameBar);
        ArrayList<X509Certificate> chain = new ArrayList<X509Certificate>();
        chain.add(this.entityCert);
        chain.add(this.caCert);
        this.credential.setEntityCertificateChain(chain);
        ArrayList<X509CRL> crls = new ArrayList<X509CRL>();
        crls.add(this.caCRL);
        this.credential.setCRLs(crls);
    }

    @Test
    public void testNoOptions() throws SecurityException {
        this.generator = this.factory.newInstance();
        KeyInfo keyInfo = this.generator.generate((Credential)this.credential);
        Assert.assertNull((Object)keyInfo, (String)"Generated KeyInfo with no options should have been null");
    }

    @Test
    public void testEmitPublicKey() throws SecurityException, KeyException {
        this.factory.setEmitPublicKeyValue(true);
        this.generator = this.factory.newInstance();
        KeyInfo keyInfo = this.generator.generate((Credential)this.credential);
        assert (keyInfo != null);
        List children = keyInfo.getOrderedChildren();
        assert (children != null);
        Assert.assertEquals((int)children.size(), (int)1, (String)"Unexpected number of KeyInfo children");
        Assert.assertEquals((int)keyInfo.getKeyValues().size(), (int)1, (String)"Unexpected number of KeyValue elements");
        PublicKey generatedKey = KeyInfoSupport.getKey((KeyValue)((KeyValue)keyInfo.getKeyValues().get(0)));
        Assert.assertEquals((Object)generatedKey, (Object)this.pubKey, (String)"Unexpected key value");
    }

    @Test
    public void testEmitKeynames() throws SecurityException {
        this.factory.setEmitKeyNames(true);
        this.generator = this.factory.newInstance();
        KeyInfo keyInfo = this.generator.generate((Credential)this.credential);
        assert (keyInfo != null);
        Assert.assertNotNull((Object)keyInfo.getOrderedChildren(), (String)"Generated KeyInfo children list was null");
        Assert.assertEquals((int)keyInfo.getKeyNames().size(), (int)2, (String)"Unexpected number of KeyName elements");
        List keyNames = KeyInfoSupport.getKeyNames((KeyInfo)keyInfo);
        Assert.assertTrue((boolean)keyNames.contains(this.keyNameFoo), (String)"Failed to find expected KeyName value");
        Assert.assertTrue((boolean)keyNames.contains(this.keyNameBar), (String)"Failed to find expected KeyName value");
    }

    @Test
    public void testEmitEntityIDAsKeyName() throws SecurityException {
        this.factory.setEmitEntityIDAsKeyName(true);
        this.generator = this.factory.newInstance();
        KeyInfo keyInfo = this.generator.generate((Credential)this.credential);
        assert (keyInfo != null);
        Assert.assertNotNull((Object)keyInfo.getOrderedChildren(), (String)"Generated KeyInfo children list was null");
        Assert.assertEquals((int)keyInfo.getKeyNames().size(), (int)1, (String)"Unexpected number of KeyName elements");
        List keyNames = KeyInfoSupport.getKeyNames((KeyInfo)keyInfo);
        Assert.assertTrue((boolean)keyNames.contains(this.entityID), (String)"Failed to find expected KeyName value");
    }

    @Test
    public void testEmitEntityCert() throws SecurityException, CertificateException {
        this.factory.setEmitEntityCertificate(true);
        this.generator = this.factory.newInstance();
        KeyInfo keyInfo = this.generator.generate((Credential)this.credential);
        assert (keyInfo != null);
        Assert.assertNotNull((Object)keyInfo.getOrderedChildren(), (String)"Generated KeyInfo children list was null");
        Assert.assertEquals((int)keyInfo.getX509Datas().size(), (int)1, (String)"Unexpected number of X509Data elements");
        X509Data x509Data = (X509Data)keyInfo.getX509Datas().get(0);
        Assert.assertEquals((int)x509Data.getX509Certificates().size(), (int)1, (String)"Unexpected number of X509Certificate elements");
        List certs = KeyInfoSupport.getCertificates((X509Data)x509Data);
        Assert.assertEquals(certs.get(0), (Object)this.entityCert, (String)"Unexpected certificate value found");
    }

    @Test
    public void testEmitEntityCertChain() throws SecurityException, CertificateException {
        this.factory.setEmitEntityCertificateChain(true);
        this.generator = this.factory.newInstance();
        KeyInfo keyInfo = this.generator.generate((Credential)this.credential);
        assert (keyInfo != null);
        Assert.assertNotNull((Object)keyInfo.getOrderedChildren(), (String)"Generated KeyInfo children list was null");
        Assert.assertEquals((int)keyInfo.getX509Datas().size(), (int)1, (String)"Unexpected number of X509Data elements");
        X509Data x509Data = (X509Data)keyInfo.getX509Datas().get(0);
        Assert.assertEquals((int)x509Data.getX509Certificates().size(), (int)2, (String)"Unexpected number of X509Certificate elements");
        List certs = KeyInfoSupport.getCertificates((X509Data)x509Data);
        Assert.assertTrue((boolean)certs.contains(this.entityCert), (String)"Expected certificate value not found");
        Assert.assertTrue((boolean)certs.contains(this.caCert), (String)"Expected certificate value not found");
    }

    @Test
    public void testEmitCertAndChainCombo() throws SecurityException, CertificateException {
        this.factory.setEmitEntityCertificate(true);
        this.factory.setEmitEntityCertificateChain(true);
        this.generator = this.factory.newInstance();
        KeyInfo keyInfo = this.generator.generate((Credential)this.credential);
        assert (keyInfo != null);
        Assert.assertNotNull((Object)keyInfo.getOrderedChildren(), (String)"Generated KeyInfo children list was null");
        Assert.assertEquals((int)keyInfo.getX509Datas().size(), (int)1, (String)"Unexpected number of X509Data elements");
        X509Data x509Data = (X509Data)keyInfo.getX509Datas().get(0);
        Assert.assertEquals((int)x509Data.getX509Certificates().size(), (int)2, (String)"Unexpected number of X509Certificate elements");
        List certs = KeyInfoSupport.getCertificates((X509Data)x509Data);
        Assert.assertTrue((boolean)certs.contains(this.entityCert), (String)"Expected certificate value not found");
        Assert.assertTrue((boolean)certs.contains(this.caCert), (String)"Expected certificate value not found");
    }

    @Test
    public void testEmitCRLs() throws SecurityException, CRLException {
        this.factory.setEmitCRLs(true);
        this.generator = this.factory.newInstance();
        KeyInfo keyInfo = this.generator.generate((Credential)this.credential);
        assert (keyInfo != null);
        Assert.assertNotNull((Object)keyInfo.getOrderedChildren(), (String)"Generated KeyInfo children list was null");
        Assert.assertEquals((int)keyInfo.getX509Datas().size(), (int)1, (String)"Unexpected number of X509Data elements");
        X509Data x509Data = (X509Data)keyInfo.getX509Datas().get(0);
        Assert.assertEquals((int)x509Data.getX509CRLs().size(), (int)1, (String)"Unexpected number of X509CRL elements");
        X509CRL crl = KeyInfoSupport.getCRL((org.opensaml.xmlsec.signature.X509CRL)((org.opensaml.xmlsec.signature.X509CRL)x509Data.getX509CRLs().get(0)));
        Assert.assertEquals((Object)crl, (Object)this.caCRL, (String)"Unexpected CRL value found");
    }

    @Test
    public void testEmitX509SubjectName() throws SecurityException {
        this.factory.setEmitX509SubjectName(true);
        this.generator = this.factory.newInstance();
        KeyInfo keyInfo = this.generator.generate((Credential)this.credential);
        assert (keyInfo != null);
        Assert.assertNotNull((Object)keyInfo.getOrderedChildren(), (String)"Generated KeyInfo children list was null");
        Assert.assertEquals((int)keyInfo.getX509Datas().size(), (int)1, (String)"Unexpected number of X509Data elements");
        X509Data x509Data = (X509Data)keyInfo.getX509Datas().get(0);
        Assert.assertEquals((int)x509Data.getX509SubjectNames().size(), (int)1, (String)"Unexpected number of X509SubjectName elements");
        String name = StringSupport.trimOrNull((String)((X509SubjectName)x509Data.getX509SubjectNames().get(0)).getValue());
        Assert.assertEquals((Object)new X500Principal(name), (Object)this.subjectName, (String)"Unexpected X509SubjectName value found");
    }

    @Test
    public void testEmitX509IssuerSerial() throws SecurityException {
        this.factory.setEmitX509IssuerSerial(true);
        this.generator = this.factory.newInstance();
        KeyInfo keyInfo = this.generator.generate((Credential)this.credential);
        assert (keyInfo != null);
        Assert.assertNotNull((Object)keyInfo.getOrderedChildren(), (String)"Generated KeyInfo children list was null");
        Assert.assertEquals((int)keyInfo.getX509Datas().size(), (int)1, (String)"Unexpected number of X509Data elements");
        X509Data x509Data = (X509Data)keyInfo.getX509Datas().get(0);
        Assert.assertEquals((int)x509Data.getX509IssuerSerials().size(), (int)1, (String)"Unexpected number of X509IssuerSerial elements");
        X509IssuerSerial issuerSerial = (X509IssuerSerial)x509Data.getX509IssuerSerials().get(0);
        X509IssuerName iname = issuerSerial.getX509IssuerName();
        assert (iname != null);
        X509SerialNumber serialNum = issuerSerial.getX509SerialNumber();
        assert (serialNum != null);
        String name = StringSupport.trimOrNull((String)iname.getValue());
        Assert.assertEquals((Object)new X500Principal(name), (Object)this.issuerName, (String)"Unexpected X509IssuerName value found");
        Assert.assertEquals((Object)serialNum.getValue(), (Object)this.serialNumber, (String)"Unexpected serial number value found");
    }

    @Test
    public void testEmitX509SKI() throws SecurityException, DecodingException {
        this.factory.setEmitX509SKI(true);
        this.generator = this.factory.newInstance();
        KeyInfo keyInfo = this.generator.generate((Credential)this.credential);
        assert (keyInfo != null);
        Assert.assertNotNull((Object)keyInfo.getOrderedChildren(), (String)"Generated KeyInfo children list was null");
        Assert.assertEquals((int)keyInfo.getX509Datas().size(), (int)1, (String)"Unexpected number of X509Data elements");
        X509Data x509Data = (X509Data)keyInfo.getX509Datas().get(0);
        Assert.assertEquals((int)x509Data.getX509SKIs().size(), (int)1, (String)"Unexpected number of X509SKI elements");
        X509SKI ski = (X509SKI)x509Data.getX509SKIs().get(0);
        byte[] skiValue = Base64Support.decode((String)((String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)ski.getValue()), (String)"SKI was null")));
        Assert.assertTrue((boolean)Arrays.equals(this.subjectKeyIdentifier, skiValue), (String)"Unexpected SKI value found");
    }

    @Test
    public void testEmitX509Digest() throws SecurityException, DecodingException {
        this.factory.setEmitX509Digest(true);
        this.factory.setX509DigestAlgorithmURI("http://www.w3.org/2000/09/xmldsig#sha1");
        this.generator = this.factory.newInstance();
        KeyInfo keyInfo = this.generator.generate((Credential)this.credential);
        assert (keyInfo != null);
        Assert.assertNotNull((Object)keyInfo.getOrderedChildren(), (String)"Generated KeyInfo children list was null");
        Assert.assertEquals((int)keyInfo.getX509Datas().size(), (int)1, (String)"Unexpected number of X509Data elements");
        X509Data x509Data = (X509Data)keyInfo.getX509Datas().get(0);
        Assert.assertEquals((int)x509Data.getX509Digests().size(), (int)1, (String)"Unexpected number of X509Digest elements");
        X509Digest digest = (X509Digest)x509Data.getX509Digests().get(0);
        byte[] digestValue = Base64Support.decode((String)((String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)digest.getValue()), (String)"Digest was null")));
        Assert.assertTrue((boolean)Arrays.equals(this.x509Digest, digestValue), (String)"Unexpected SHA-1 digest value found");
    }

    @Test
    public void testEmitSubjectDNAsKeyName() throws SecurityException {
        this.factory.setEmitSubjectDNAsKeyName(true);
        this.generator = this.factory.newInstance();
        KeyInfo keyInfo = this.generator.generate((Credential)this.credential);
        assert (keyInfo != null);
        Assert.assertNotNull((Object)keyInfo.getOrderedChildren(), (String)"Generated KeyInfo children list was null");
        Assert.assertEquals((int)keyInfo.getKeyNames().size(), (int)1, (String)"Unexpected number of KeyName elements");
        List keyNames = KeyInfoSupport.getKeyNames((KeyInfo)keyInfo);
        String name = StringSupport.trimOrNull((String)((String)keyNames.get(0)));
        Assert.assertEquals((Object)new X500Principal(name), (Object)this.subjectName, (String)"Unexpected subject DN key name value found");
    }

    @Test
    public void testEmitSubjectCNAsKeyName() throws SecurityException {
        this.factory.setEmitSubjectCNAsKeyName(true);
        this.generator = this.factory.newInstance();
        KeyInfo keyInfo = this.generator.generate((Credential)this.credential);
        assert (keyInfo != null);
        Assert.assertNotNull((Object)keyInfo.getOrderedChildren(), (String)"Generated KeyInfo children list was null");
        Assert.assertEquals((int)keyInfo.getKeyNames().size(), (int)1, (String)"Unexpected number of KeyName elements");
        List keyNames = KeyInfoSupport.getKeyNames((KeyInfo)keyInfo);
        Assert.assertTrue((boolean)keyNames.contains(this.subjectCN), (String)"Failed to find expected KeyName value");
    }

    @Test
    public void testEmitSubjectAltNamesAsKeyNames() throws SecurityException, CertificateParsingException {
        this.factory.setEmitSubjectAltNamesAsKeyNames(true);
        this.generator = this.factory.newInstance();
        KeyInfo keyInfo = this.generator.generate((Credential)this.credential);
        Assert.assertNull((Object)keyInfo, (String)"Generated KeyInfo was not null");
        byte[] extensionValue = this.credential.getEntityCertificate().getExtensionValue(subjectAltNameExtensionOID);
        Assert.assertNotNull((Object)extensionValue, (String)"Entity cert's Java native getExtensionValue() was null");
        Assert.assertTrue((extensionValue.length > 0 ? 1 : 0) != 0, (String)"Entity cert's extension value was empty");
        this.factory.getSubjectAltNames().add(this.altName1Type);
        this.generator = this.factory.newInstance();
        keyInfo = this.generator.generate((Credential)this.credential);
        assert (keyInfo != null);
        Assert.assertNotNull((Object)keyInfo.getOrderedChildren(), (String)"Generated KeyInfo children list was null");
        Assert.assertEquals((int)keyInfo.getKeyNames().size(), (int)1, (String)"Unexpected number of KeyName elements");
        List keyNames = KeyInfoSupport.getKeyNames((KeyInfo)keyInfo);
        Assert.assertTrue((boolean)keyNames.contains(this.altName1), (String)"Failed to find expected KeyName value");
        this.factory.getSubjectAltNames().add(this.altName2Type);
        this.factory.getSubjectAltNames().add(this.altName3Type);
        this.generator = this.factory.newInstance();
        keyInfo = this.generator.generate((Credential)this.credential);
        assert (keyInfo != null);
        Assert.assertNotNull((Object)keyInfo.getOrderedChildren(), (String)"Generated KeyInfo children list was null");
        Assert.assertEquals((int)keyInfo.getKeyNames().size(), (int)3, (String)"Unexpected number of KeyName elements");
        keyNames = KeyInfoSupport.getKeyNames((KeyInfo)keyInfo);
        Assert.assertTrue((boolean)keyNames.contains(this.altName1), (String)"Failed to find expected KeyName value");
        Assert.assertTrue((boolean)keyNames.contains(this.altName2), (String)"Failed to find expected KeyName value");
        Assert.assertTrue((boolean)keyNames.contains(this.altName3), (String)"Failed to find expected KeyName value");
    }

    @Test
    public void testEmitKeyNamesCombo() throws SecurityException {
        this.factory.setEmitKeyNames(true);
        this.factory.setEmitEntityIDAsKeyName(true);
        this.factory.setEmitSubjectCNAsKeyName(true);
        this.factory.setEmitSubjectAltNamesAsKeyNames(true);
        this.factory.getSubjectAltNames().add(this.altName1Type);
        this.factory.getSubjectAltNames().add(this.altName2Type);
        this.factory.getSubjectAltNames().add(this.altName3Type);
        this.generator = this.factory.newInstance();
        KeyInfo keyInfo = this.generator.generate((Credential)this.credential);
        assert (keyInfo != null);
        Assert.assertNotNull((Object)keyInfo.getOrderedChildren(), (String)"Generated KeyInfo children list was null");
        Assert.assertEquals((int)keyInfo.getKeyNames().size(), (int)7, (String)"Unexpected number of KeyName elements");
        List keyNames = KeyInfoSupport.getKeyNames((KeyInfo)keyInfo);
        Assert.assertTrue((boolean)keyNames.contains(this.keyNameFoo), (String)"Failed to find expected KeyName value");
        Assert.assertTrue((boolean)keyNames.contains(this.keyNameBar), (String)"Failed to find expected KeyName value");
        Assert.assertTrue((boolean)keyNames.contains(this.entityID), (String)"Failed to find expected KeyName value");
        Assert.assertTrue((boolean)keyNames.contains(this.subjectCN), (String)"Failed to find expected KeyName value");
        Assert.assertTrue((boolean)keyNames.contains(this.altName1), (String)"Failed to find expected KeyName value");
        Assert.assertTrue((boolean)keyNames.contains(this.altName2), (String)"Failed to find expected KeyName value");
        Assert.assertTrue((boolean)keyNames.contains(this.altName3), (String)"Failed to find expected KeyName value");
    }

    @Test
    public void testProperOptionsCloning() throws SecurityException {
        this.generator = this.factory.newInstance();
        KeyInfo keyInfo = this.generator.generate((Credential)this.credential);
        Assert.assertNull((Object)keyInfo, (String)"Generated KeyInfo was null");
        this.factory.setEmitKeyNames(true);
        this.factory.setEmitEntityIDAsKeyName(true);
        this.factory.setEmitPublicKeyValue(true);
        keyInfo = this.generator.generate((Credential)this.credential);
        Assert.assertNull((Object)keyInfo, (String)"Generated KeyInfo was null");
        this.generator = this.factory.newInstance();
        keyInfo = this.generator.generate((Credential)this.credential);
        assert (keyInfo != null);
        List children = keyInfo.getOrderedChildren();
        assert (children != null);
        Assert.assertEquals((int)children.size(), (int)4, (String)"Unexpected # of KeyInfo children found");
    }

    @DataProvider
    @Nonnull
    public Object[][] keyInfoTypes() {
        return new Object[][]{{KeyInfo.class}, {OriginatorKeyInfo.class}, {RecipientKeyInfo.class}};
    }

    @Test(dataProvider="keyInfoTypes")
    public void testKeyInfoElementType(Class<? extends KeyInfo> type) throws SecurityException, CertificateException {
        this.factory.setEmitEntityCertificate(true);
        this.generator = this.factory.newInstance(type);
        KeyInfo keyInfo = this.generator.generate((Credential)this.credential);
        assert (keyInfo != null);
        Assert.assertNotNull((Object)keyInfo.getOrderedChildren(), (String)"Generated KeyInfo children list was null");
        Assert.assertTrue((boolean)type.isInstance(keyInfo));
        Assert.assertEquals((int)keyInfo.getX509Datas().size(), (int)1, (String)"Unexpected number of X509Data elements");
        X509Data x509Data = (X509Data)keyInfo.getX509Datas().get(0);
        Assert.assertEquals((int)x509Data.getX509Certificates().size(), (int)1, (String)"Unexpected number of X509Certificate elements");
        List certs = KeyInfoSupport.getCertificates((X509Data)x509Data);
        Assert.assertEquals(certs.get(0), (Object)this.entityCert, (String)"Unexpected certificate value found");
    }
}

