/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.messaging.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.xmlsec.SignatureValidationParameters;
import org.opensaml.xmlsec.SignatureValidationParametersResolver;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.criterion.SignatureValidationConfigurationCriterion;
import org.opensaml.xmlsec.messaging.impl.PopulateSignatureValidationParametersHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PopulateSignatureValidationParametersHandlerTest
extends OpenSAMLInitBaseTestCase {
    private MessageContext messageContext;
    private PopulateSignatureValidationParametersHandler handler;

    @BeforeMethod
    public void setUp() {
        this.messageContext = new MessageContext();
        this.handler = new PopulateSignatureValidationParametersHandler();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testConfig() throws ComponentInitializationException {
        this.handler.initialize();
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testResolverError() throws Exception {
        this.handler.setSignatureValidationParametersResolver((SignatureValidationParametersResolver)new MockResolver(true));
        this.handler.initialize();
        this.handler.invoke(this.messageContext);
    }

    @Test
    public void testSuccess() throws Exception {
        this.handler.setSignatureValidationParametersResolver((SignatureValidationParametersResolver)new MockResolver(false));
        this.handler.initialize();
        this.handler.invoke(this.messageContext);
        Assert.assertNotNull((Object)((SecurityParametersContext)this.messageContext.ensureSubcontext(SecurityParametersContext.class)).getSignatureValidationParameters());
    }

    private class MockResolver
    implements SignatureValidationParametersResolver {
        private boolean throwException;

        public MockResolver(boolean shouldThrow) {
            this.throwException = shouldThrow;
        }

        @Nonnull
        public Iterable<SignatureValidationParameters> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
            SignatureValidationParameters params = this.resolveSingle(criteria);
            if (params != null) {
                return CollectionSupport.singletonList((Object)params);
            }
            return CollectionSupport.emptyList();
        }

        @Nullable
        public SignatureValidationParameters resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
            if (this.throwException) {
                throw new ResolverException();
            }
            assert (criteria != null);
            Constraint.isNotNull((Object)((SignatureValidationConfigurationCriterion)criteria.get(SignatureValidationConfigurationCriterion.class)), (String)"Criterion was null");
            return new SignatureValidationParameters();
        }
    }
}

