/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xmlsec.signature.DSAKeyValue;
import org.opensaml.xmlsec.signature.G;
import org.opensaml.xmlsec.signature.J;
import org.opensaml.xmlsec.signature.P;
import org.opensaml.xmlsec.signature.PgenCounter;
import org.opensaml.xmlsec.signature.Q;
import org.opensaml.xmlsec.signature.Seed;
import org.opensaml.xmlsec.signature.Y;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DSAKeyValueTest
extends XMLObjectProviderBaseTestCase {
    public DSAKeyValueTest() {
        this.singleElementFile = "/org/opensaml/xmlsec/signature/impl/DSAKeyValue.xml";
        this.childElementsFile = "/org/opensaml/xmlsec/signature/impl/DSAKeyValueChildElements.xml";
    }

    @Test
    public void testSingleElementUnmarshall() {
        DSAKeyValue keyValue = (DSAKeyValue)this.unmarshallElement(this.singleElementFile);
        assert (keyValue != null);
        Assert.assertNull((Object)keyValue.getP(), (String)"P child element");
        Assert.assertNull((Object)keyValue.getQ(), (String)"Q child element");
        Assert.assertNull((Object)keyValue.getG(), (String)"G child element");
        Assert.assertNull((Object)keyValue.getY(), (String)"Y child element");
        Assert.assertNull((Object)keyValue.getJ(), (String)"J child element");
        Assert.assertNull((Object)keyValue.getSeed(), (String)"Seed element");
        Assert.assertNull((Object)keyValue.getPgenCounter(), (String)"PgenCounter element");
    }

    @Test
    public void testChildElementsUnmarshall() {
        DSAKeyValue keyValue = (DSAKeyValue)this.unmarshallElement(this.childElementsFile);
        assert (keyValue != null);
        Assert.assertNotNull((Object)keyValue.getP(), (String)"P child element");
        Assert.assertNotNull((Object)keyValue.getQ(), (String)"Q child element");
        Assert.assertNotNull((Object)keyValue.getG(), (String)"G child element");
        Assert.assertNotNull((Object)keyValue.getY(), (String)"Y child element");
        Assert.assertNotNull((Object)keyValue.getJ(), (String)"J child element");
        Assert.assertNotNull((Object)keyValue.getSeed(), (String)"Seed element");
        Assert.assertNotNull((Object)keyValue.getPgenCounter(), (String)"PgenCounter element");
    }

    @Test
    public void testSingleElementMarshall() {
        DSAKeyValue keyValue = (DSAKeyValue)this.buildXMLObject(DSAKeyValue.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)keyValue);
    }

    @Test
    public void testChildElementsMarshall() {
        DSAKeyValue keyValue = (DSAKeyValue)this.buildXMLObject(DSAKeyValue.DEFAULT_ELEMENT_NAME);
        keyValue.setP((P)this.buildXMLObject(P.DEFAULT_ELEMENT_NAME));
        keyValue.setQ((Q)this.buildXMLObject(Q.DEFAULT_ELEMENT_NAME));
        keyValue.setG((G)this.buildXMLObject(G.DEFAULT_ELEMENT_NAME));
        keyValue.setY((Y)this.buildXMLObject(Y.DEFAULT_ELEMENT_NAME));
        keyValue.setJ((J)this.buildXMLObject(J.DEFAULT_ELEMENT_NAME));
        keyValue.setSeed((Seed)this.buildXMLObject(Seed.DEFAULT_ELEMENT_NAME));
        keyValue.setPgenCounter((PgenCounter)this.buildXMLObject(PgenCounter.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)keyValue);
    }
}

