/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.mock.SimpleXMLObject;
import org.opensaml.xmlsec.signature.DigestMethod;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DigestMethodTest
extends XMLObjectProviderBaseTestCase {
    private String expectedAlgorithm;
    private int expectedTotalChildren;

    public DigestMethodTest() {
        this.singleElementFile = "/org/opensaml/xmlsec/signature/impl/DigestMethod.xml";
        this.childElementsFile = "/org/opensaml/xmlsec/signature/impl/DigestMethodChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedAlgorithm = "urn:string:foo";
        this.expectedTotalChildren = 3;
    }

    @Test
    public void testSingleElementUnmarshall() {
        DigestMethod digestMethod = (DigestMethod)this.unmarshallElement(this.singleElementFile);
        assert (digestMethod != null);
        Assert.assertEquals((String)digestMethod.getAlgorithm(), (String)this.expectedAlgorithm, (String)"Algorithm attribute");
        Assert.assertEquals((int)digestMethod.getUnknownXMLObjects().size(), (int)0, (String)"Total children");
    }

    @Test
    public void testChildElementsUnmarshall() {
        DigestMethod digestMethod = (DigestMethod)this.unmarshallElement(this.childElementsFile);
        assert (digestMethod != null);
        Assert.assertEquals((String)digestMethod.getAlgorithm(), (String)this.expectedAlgorithm, (String)"Algorithm attribute");
        Assert.assertEquals((int)digestMethod.getUnknownXMLObjects().size(), (int)this.expectedTotalChildren, (String)"Total children");
    }

    @Test
    public void testSingleElementMarshall() {
        DigestMethod digestMethod = (DigestMethod)this.buildXMLObject(DigestMethod.DEFAULT_ELEMENT_NAME);
        digestMethod.setAlgorithm(this.expectedAlgorithm);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)digestMethod);
    }

    @Test
    public void testChildElementsMarshall() {
        DigestMethod digestMethod = (DigestMethod)this.buildXMLObject(DigestMethod.DEFAULT_ELEMENT_NAME);
        digestMethod.setAlgorithm(this.expectedAlgorithm);
        digestMethod.getUnknownXMLObjects().add(this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        digestMethod.getUnknownXMLObjects().add(this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        digestMethod.getUnknownXMLObjects().add(this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)digestMethod);
    }
}

