/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xmlsec.signature.KeyValue;
import org.opensaml.xmlsec.signature.RSAKeyValue;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KeyValueTest
extends XMLObjectProviderBaseTestCase {
    public KeyValueTest() {
        this.singleElementFile = "/org/opensaml/xmlsec/signature/impl/KeyValue.xml";
        this.childElementsFile = "/org/opensaml/xmlsec/signature/impl/KeyValueChildElements.xml";
    }

    @Test
    public void testSingleElementUnmarshall() {
        KeyValue keyValue = (KeyValue)this.unmarshallElement(this.singleElementFile);
        assert (keyValue != null);
        Assert.assertNull((Object)keyValue.getRSAKeyValue(), (String)"RSAKeyValue child element");
        Assert.assertNull((Object)keyValue.getDSAKeyValue(), (String)"DSAKeyValue child element");
        Assert.assertNull((Object)keyValue.getUnknownXMLObject(), (String)"Wildcard child element");
    }

    @Test
    public void testChildElementsUnmarshall() {
        KeyValue keyValue = (KeyValue)this.unmarshallElement(this.childElementsFile);
        assert (keyValue != null);
        Assert.assertNotNull((Object)keyValue.getRSAKeyValue(), (String)"RSAKeyValue child element");
        Assert.assertNull((Object)keyValue.getDSAKeyValue(), (String)"DSAKeyValue child element");
        Assert.assertNull((Object)keyValue.getUnknownXMLObject(), (String)"Wildcard child element");
    }

    @Test
    public void testSingleElementMarshall() {
        KeyValue keyValue = (KeyValue)this.buildXMLObject(KeyValue.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)keyValue);
    }

    @Test
    public void testChildElementsMarshall() {
        KeyValue keyValue = (KeyValue)this.buildXMLObject(KeyValue.DEFAULT_ELEMENT_NAME);
        keyValue.setRSAKeyValue((RSAKeyValue)this.buildXMLObject(RSAKeyValue.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)keyValue);
    }
}

