/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xmlsec.signature.Exponent;
import org.opensaml.xmlsec.signature.Modulus;
import org.opensaml.xmlsec.signature.RSAKeyValue;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RSAKeyValueTest
extends XMLObjectProviderBaseTestCase {
    public RSAKeyValueTest() {
        this.singleElementFile = "/org/opensaml/xmlsec/signature/impl/RSAKeyValue.xml";
        this.childElementsFile = "/org/opensaml/xmlsec/signature/impl/RSAKeyValueChildElements.xml";
    }

    @Test
    public void testSingleElementUnmarshall() {
        RSAKeyValue keyValue = (RSAKeyValue)this.unmarshallElement(this.singleElementFile);
        assert (keyValue != null);
        Assert.assertNull((Object)keyValue.getModulus(), (String)"Modulus child element");
        Assert.assertNull((Object)keyValue.getExponent(), (String)"Exponent child element");
    }

    @Test
    public void testChildElementsUnmarshall() {
        RSAKeyValue keyValue = (RSAKeyValue)this.unmarshallElement(this.childElementsFile);
        assert (keyValue != null);
        Assert.assertNotNull((Object)keyValue.getModulus(), (String)"Modulus child element");
        Assert.assertNotNull((Object)keyValue.getExponent(), (String)"Exponent child element");
    }

    @Test
    public void testSingleElementMarshall() {
        RSAKeyValue keyValue = (RSAKeyValue)this.buildXMLObject(RSAKeyValue.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)keyValue);
    }

    @Test
    public void testChildElementsMarshall() {
        RSAKeyValue keyValue = (RSAKeyValue)this.buildXMLObject(RSAKeyValue.DEFAULT_ELEMENT_NAME);
        keyValue.setModulus((Modulus)this.buildXMLObject(Modulus.DEFAULT_ELEMENT_NAME));
        keyValue.setExponent((Exponent)this.buildXMLObject(Exponent.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)keyValue);
    }
}

