/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.support.impl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.opensaml.xmlsec.signature.support.impl.ChainingSignatureTrustEngine;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ChainingSignatureTrustEngineTest
extends XMLObjectBaseTestCase {
    private CriteriaSet criteriaSet;
    private ChainingSignatureTrustEngine engine;
    private List<SignatureTrustEngine> chain;
    private Signature token;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.token = (Signature)this.buildXMLObject(Signature.DEFAULT_ELEMENT_NAME);
        this.chain = new ArrayList<SignatureTrustEngine>();
        this.criteriaSet = new CriteriaSet();
        this.criteriaSet.add((Object)new EntityIdCriterion("dummyEntityID"));
    }

    @Test
    public void testFirstTrusted() throws SecurityException {
        this.chain.add(new MockSignatureTrustEngine(Boolean.TRUE));
        this.chain.add(new MockSignatureTrustEngine(Boolean.FALSE));
        this.engine = new ChainingSignatureTrustEngine(this.chain);
        Assert.assertTrue((boolean)this.engine.validate(this.token, this.criteriaSet), (String)"Engine # 1 evaled token as trusted");
    }

    @Test
    public void testSecondTrusted() throws SecurityException {
        this.chain.add(new MockSignatureTrustEngine(Boolean.FALSE));
        this.chain.add(new MockSignatureTrustEngine(Boolean.TRUE));
        this.engine = new ChainingSignatureTrustEngine(this.chain);
        Assert.assertTrue((boolean)this.engine.validate(this.token, this.criteriaSet), (String)"Engine # 2 evaled token as trusted");
    }

    @Test
    public void testNoneTrusted() throws SecurityException {
        this.chain.add(new MockSignatureTrustEngine(Boolean.FALSE));
        this.chain.add(new MockSignatureTrustEngine(Boolean.FALSE));
        this.engine = new ChainingSignatureTrustEngine(this.chain);
        Assert.assertFalse((boolean)this.engine.validate(this.token, this.criteriaSet), (String)"No engine evaled token as trusted");
    }

    @Test(expectedExceptions={SecurityException.class})
    public void testException() throws SecurityException {
        this.chain.add(new MockSignatureTrustEngine(Boolean.FALSE));
        this.chain.add(new MockSignatureTrustEngine(null));
        this.engine = new ChainingSignatureTrustEngine(this.chain);
        this.engine.validate(this.token, this.criteriaSet);
    }

    private class MockSignatureTrustEngine
    implements SignatureTrustEngine {
        private Boolean trusted;

        private MockSignatureTrustEngine(Boolean flag) {
            this.trusted = flag;
        }

        public boolean validate(@Nonnull Signature tok, @Nullable CriteriaSet trustBasisCriteria) throws SecurityException {
            if (this.trusted == null) {
                throw new SecurityException("This means an error happened");
            }
            return this.trusted;
        }

        public boolean validate(@Nonnull byte[] signature, @Nonnull byte[] content, @Nonnull String algorithmURI, @Nullable CriteriaSet trustBasisCriteria, @Nullable Credential candidateCredential) throws SecurityException {
            if (this.trusted == null) {
                throw new SecurityException("This means an error happened");
            }
            return this.trusted;
        }

        @Nullable
        public KeyInfoCredentialResolver getKeyInfoResolver() {
            return null;
        }
    }
}

