/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.support.impl;

import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.PKIXValidationInformation;
import org.opensaml.security.x509.PKIXValidationInformationResolver;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.security.x509.X509Support;
import org.opensaml.security.x509.impl.BasicPKIXValidationInformation;
import org.opensaml.security.x509.impl.StaticPKIXValidationInformationResolver;
import org.opensaml.xmlsec.SignatureValidationParameters;
import org.opensaml.xmlsec.crypto.XMLSigningUtil;
import org.opensaml.xmlsec.keyinfo.impl.X509KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.mock.SignableSimpleXMLObject;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.DocumentInternalIDContentReference;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureValidationParametersCriterion;
import org.opensaml.xmlsec.signature.support.Signer;
import org.opensaml.xmlsec.signature.support.impl.PKIXSignatureTrustEngine;
import org.opensaml.xmlsec.testing.XMLSecurityTestingSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class PKIXSignatureTrustEngineTest
extends XMLObjectBaseTestCase {
    private static final String DATA_PATH = "/org/opensaml/xmlsec/signature/support/";
    private static final Set<X509CRL> EMPTY_CRLS = new HashSet<X509CRL>();
    private static final Set<X509Certificate> EMPTY_ANCHORS = new HashSet<X509Certificate>();
    private static final Integer MAX_DEPTH = 10;
    private PKIXSignatureTrustEngine engine;
    private Signature signature;
    private CriteriaSet criteriaSet;
    private String subjectCN;
    private boolean tamperDocumentPostSigning;
    private boolean emitKeyInfo;
    private boolean emitKeyValueOnly;
    private String rawData;
    private byte[] rawSignedContent;
    private String rawAlgorithmURI;
    private byte[] rawSignature;
    private Credential rawCandidateCred;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.subjectCN = "foo.example.org";
        this.criteriaSet = new CriteriaSet(new Criterion[]{new EntityIdCriterion("dummy-entity-id")});
        this.tamperDocumentPostSigning = false;
        this.emitKeyInfo = true;
        this.emitKeyValueOnly = false;
        this.rawData = "Hello, here is some secret data that is to be signed";
        this.rawSignedContent = this.rawData.getBytes();
        this.rawAlgorithmURI = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    }

    @Test
    public void testGoodPathInAnchors() {
        this.signature = this.getSignature("foo-1A1-good.crt", "foo-1A1-good.key", new String[0]);
        this.engine = this.getEngine(this.getCertificates("root1-ca.crt", "inter1A-ca.crt", "inter1A1-ca.crt"), EMPTY_CRLS, MAX_DEPTH, this.subjectCN);
        this.testValidateSuccess("Entity cert was good, path in trust anchors set");
    }

    @Test
    public void testGoodPathInCred() {
        this.signature = this.getSignature("foo-1A1-good.crt", "foo-1A1-good.key", "inter1A-ca.crt", "inter1A1-ca.crt");
        this.engine = this.getEngine(this.getCertificates("root1-ca.crt"), EMPTY_CRLS, MAX_DEPTH, this.subjectCN);
        this.testValidateSuccess("Entity cert was good, full path in cred");
    }

    @Test
    public void testGoodPathNoTrustedNames() {
        this.signature = this.getSignature("foo-1A1-good.crt", "foo-1A1-good.key", "inter1A-ca.crt", "inter1A1-ca.crt");
        this.engine = this.getEngine(this.getCertificates("root1-ca.crt"), EMPTY_CRLS, MAX_DEPTH, new String[0]);
        this.testValidateFailure("Entity cert was good, full path in cred, no trusted names");
    }

    @Test
    public void testGoodPathBadTrustedName() {
        this.signature = this.getSignature("foo-1A1-good.crt", "foo-1A1-good.key", "inter1A-ca.crt", "inter1A1-ca.crt");
        this.engine = this.getEngine(this.getCertificates("root1-ca.crt"), EMPTY_CRLS, MAX_DEPTH, "NOT" + this.subjectCN);
        this.testValidateFailure("Entity cert was good, full path in cred, bad trusted names");
    }

    @Test
    public void testCertRevoked() {
        this.signature = this.getSignature("foo-1A1-revoked.crt", "foo-1A1-good.key", "inter1A-ca.crt", "inter1A1-ca.crt");
        this.engine = this.getEngine(this.getCertificates("root1-ca.crt"), this.getCRLS("inter1A1-v1.crl"), MAX_DEPTH, this.subjectCN);
        this.testValidateFailure("Entity cert was revoked");
    }

    @Test
    public void testCertExpired() {
        this.signature = this.getSignature("foo-1A1-expired.crt", "foo-1A1-good.key", "inter1A-ca.crt", "inter1A1-ca.crt");
        this.engine = this.getEngine(this.getCertificates("root1-ca.crt"), EMPTY_CRLS, MAX_DEPTH, this.subjectCN);
        this.testValidateFailure("Entity cert was expired");
    }

    @Test
    public void testMissingAnchor() {
        this.signature = this.getSignature("foo-1A1-good.crt", "foo-1A1-good.key", "inter1A-ca.crt", "inter1A1-ca.crt");
        this.engine = this.getEngine(this.getCertificates("root2-ca.crt", "inter2A-ca.crt", "inter2B-ca.crt"), EMPTY_CRLS, MAX_DEPTH, this.subjectCN);
        this.testValidateFailure("No path to entity cert, root CA trust anchor missing");
    }

    @Test
    public void testNoAnchors() {
        this.signature = this.getSignature("foo-1A1-good.crt", "foo-1A1-good.key", "inter1A-ca.crt", "inter1A1-ca.crt");
        this.engine = this.getEngine(EMPTY_ANCHORS, EMPTY_CRLS, MAX_DEPTH, this.subjectCN);
        this.testValidateFailure("No trust anchors at all in validation set");
    }

    @Test
    public void testTamperedData() throws SecurityException {
        this.tamperDocumentPostSigning = true;
        this.signature = this.getSignature("foo-1A1-good.crt", "foo-1A1-good.key", new String[0]);
        this.engine = this.getEngine(this.getCertificates("root1-ca.crt", "inter1A-ca.crt", "inter1A1-ca.crt"), EMPTY_CRLS, MAX_DEPTH, this.subjectCN);
        this.testValidateFailure("Entity cert was good, data was tampered with");
    }

    @Test
    public void testNoCandidateCred() throws SecurityException {
        this.emitKeyInfo = false;
        this.signature = this.getSignature("foo-1A1-good.crt", "foo-1A1-good.key", new String[0]);
        this.engine = this.getEngine(this.getCertificates("root1-ca.crt", "inter1A-ca.crt", "inter1A1-ca.crt"), EMPTY_CRLS, MAX_DEPTH, this.subjectCN);
        this.testValidateFailure("Entity cert was good, but validation credential was not present in Signature's KeyInfo");
    }

    @Test
    public void testWrongCredType() throws SecurityException {
        this.emitKeyValueOnly = true;
        this.signature = this.getSignature("foo-1A1-good.crt", "foo-1A1-good.key", new String[0]);
        this.engine = this.getEngine(this.getCertificates("root1-ca.crt", "inter1A-ca.crt", "inter1A1-ca.crt"), EMPTY_CRLS, MAX_DEPTH, this.subjectCN);
        this.testValidateFailure("Entity cert was good, but validation credential in KeyInfo was not an X509Credential");
    }

    @Test
    public void testWhitelistedAlgorithms() {
        HashSet<String> algos = new HashSet<String>();
        algos.add("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        algos.add("http://www.w3.org/2000/09/xmldsig#sha1");
        SignatureValidationParameters validationParams = new SignatureValidationParameters();
        validationParams.setIncludedAlgorithms(algos);
        this.criteriaSet.add((Object)new SignatureValidationParametersCriterion(validationParams));
        this.signature = this.getSignature("foo-1A1-good.crt", "foo-1A1-good.key", new String[0]);
        this.engine = this.getEngine(this.getCertificates("root1-ca.crt", "inter1A-ca.crt", "inter1A1-ca.crt"), EMPTY_CRLS, MAX_DEPTH, this.subjectCN);
        this.testValidateSuccess("Signature was valid with whitelisted algorithms");
    }

    @Test
    public void testBlacklistedSignatureAlgorithm() {
        HashSet<String> algos = new HashSet<String>();
        algos.add("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        SignatureValidationParameters validationParams = new SignatureValidationParameters();
        validationParams.setExcludedAlgorithms(algos);
        this.criteriaSet.add((Object)new SignatureValidationParametersCriterion(validationParams));
        this.signature = this.getSignature("foo-1A1-good.crt", "foo-1A1-good.key", new String[0]);
        this.engine = this.getEngine(this.getCertificates("root1-ca.crt", "inter1A-ca.crt", "inter1A1-ca.crt"), EMPTY_CRLS, MAX_DEPTH, this.subjectCN);
        this.testValidateFailure("Signature algorithm was blacklisted");
    }

    @Test
    public void testBlacklistedDigestAlgorithm() {
        HashSet<String> algos = new HashSet<String>();
        algos.add("http://www.w3.org/2000/09/xmldsig#sha1");
        SignatureValidationParameters validationParams = new SignatureValidationParameters();
        validationParams.setExcludedAlgorithms(algos);
        this.criteriaSet.add((Object)new SignatureValidationParametersCriterion(validationParams));
        this.signature = this.getSignature("foo-1A1-good.crt", "foo-1A1-good.key", new String[0]);
        this.engine = this.getEngine(this.getCertificates("root1-ca.crt", "inter1A-ca.crt", "inter1A1-ca.crt"), EMPTY_CRLS, MAX_DEPTH, this.subjectCN);
        this.testValidateFailure("Digest algorithm was blacklisted");
    }

    @Test
    public void testRawGoodPathInAnchors() throws SecurityException {
        this.rawCandidateCred = this.getCredential("foo-1A1-good.crt", "foo-1A1-good.key", new String[0]);
        this.rawSignature = XMLSigningUtil.signWithURI((Credential)this.rawCandidateCred, (String)this.rawAlgorithmURI, (byte[])this.rawSignedContent);
        this.engine = this.getEngine(this.getCertificates("root1-ca.crt", "inter1A-ca.crt", "inter1A1-ca.crt"), EMPTY_CRLS, MAX_DEPTH, this.subjectCN);
        this.testRawValidateSuccess("Entity cert was good, path in trust anchors set");
    }

    @Test
    public void testRawGoodPathInCred() throws SecurityException {
        this.rawCandidateCred = this.getCredential("foo-1A1-good.crt", "foo-1A1-good.key", "inter1A-ca.crt", "inter1A1-ca.crt");
        this.rawSignature = XMLSigningUtil.signWithURI((Credential)this.rawCandidateCred, (String)this.rawAlgorithmURI, (byte[])this.rawSignedContent);
        this.engine = this.getEngine(this.getCertificates("root1-ca.crt"), EMPTY_CRLS, MAX_DEPTH, this.subjectCN);
        this.testRawValidateSuccess("Entity cert was good, path in cred set");
    }

    @Test
    public void testRawGoodPathNoTrustedNames() throws SecurityException {
        this.rawCandidateCred = this.getCredential("foo-1A1-good.crt", "foo-1A1-good.key", "inter1A-ca.crt", "inter1A1-ca.crt");
        this.rawSignature = XMLSigningUtil.signWithURI((Credential)this.rawCandidateCred, (String)this.rawAlgorithmURI, (byte[])this.rawSignedContent);
        this.engine = this.getEngine(this.getCertificates("root1-ca.crt"), EMPTY_CRLS, MAX_DEPTH, new String[0]);
        this.testRawValidateFailure("Entity cert was good, empty trusted names");
    }

    @Test
    public void testRawGoodPathBadTrustedName() throws SecurityException {
        this.rawCandidateCred = this.getCredential("foo-1A1-good.crt", "foo-1A1-good.key", "inter1A-ca.crt", "inter1A1-ca.crt");
        this.rawSignature = XMLSigningUtil.signWithURI((Credential)this.rawCandidateCred, (String)this.rawAlgorithmURI, (byte[])this.rawSignedContent);
        this.engine = this.getEngine(this.getCertificates("root1-ca.crt"), EMPTY_CRLS, MAX_DEPTH, "NOT" + this.subjectCN);
        this.testRawValidateFailure("Entity cert was good, bad trusted names");
    }

    @Test
    public void testRawCertRevoked() throws SecurityException {
        this.rawCandidateCred = this.getCredential("foo-1A1-revoked.crt", "foo-1A1-good.key", "inter1A-ca.crt", "inter1A1-ca.crt");
        this.rawSignature = XMLSigningUtil.signWithURI((Credential)this.rawCandidateCred, (String)this.rawAlgorithmURI, (byte[])this.rawSignedContent);
        this.engine = this.getEngine(this.getCertificates("root1-ca.crt"), this.getCRLS("inter1A1-v1.crl"), MAX_DEPTH, this.subjectCN);
        this.testRawValidateFailure("Entity cert was revoked");
    }

    @Test
    public void testRawCertExpired() throws SecurityException {
        this.rawCandidateCred = this.getCredential("foo-1A1-expired.crt", "foo-1A1-good.key", "inter1A-ca.crt", "inter1A1-ca.crt");
        this.rawSignature = XMLSigningUtil.signWithURI((Credential)this.rawCandidateCred, (String)this.rawAlgorithmURI, (byte[])this.rawSignedContent);
        this.engine = this.getEngine(this.getCertificates("root1-ca.crt"), EMPTY_CRLS, MAX_DEPTH, this.subjectCN);
        this.testRawValidateFailure("Entity cert was expired");
    }

    @Test
    public void testRawCertMissingAnchor() throws SecurityException {
        this.rawCandidateCred = this.getCredential("foo-1A1-good.crt", "foo-1A1-good.key", "inter1A-ca.crt", "inter1A1-ca.crt");
        this.rawSignature = XMLSigningUtil.signWithURI((Credential)this.rawCandidateCred, (String)this.rawAlgorithmURI, (byte[])this.rawSignedContent);
        this.engine = this.getEngine(this.getCertificates("root2-ca.crt", "inter2A-ca.crt", "inter2B-ca.crt"), EMPTY_CRLS, MAX_DEPTH, this.subjectCN);
        this.testRawValidateFailure("No path to entity cert, root CA trust anchor missing");
    }

    @Test
    public void testRawCertNoAnchors() throws SecurityException {
        this.rawCandidateCred = this.getCredential("foo-1A1-good.crt", "foo-1A1-good.key", "inter1A-ca.crt", "inter1A1-ca.crt");
        this.rawSignature = XMLSigningUtil.signWithURI((Credential)this.rawCandidateCred, (String)this.rawAlgorithmURI, (byte[])this.rawSignedContent);
        this.engine = this.getEngine(EMPTY_ANCHORS, EMPTY_CRLS, MAX_DEPTH, this.subjectCN);
        this.testRawValidateFailure("No trust anchors at all in validation set");
    }

    @Test
    public void testRawTamperedData() throws SecurityException {
        this.rawCandidateCred = this.getCredential("foo-1A1-good.crt", "foo-1A1-good.key", new String[0]);
        this.rawSignature = XMLSigningUtil.signWithURI((Credential)this.rawCandidateCred, (String)this.rawAlgorithmURI, (byte[])this.rawSignedContent);
        this.rawSignedContent = (this.rawData + "HAHA All your base are belong to us").getBytes();
        this.engine = this.getEngine(this.getCertificates("root1-ca.crt", "inter1A-ca.crt", "inter1A1-ca.crt"), EMPTY_CRLS, MAX_DEPTH, this.subjectCN);
        this.testRawValidateFailure("Entity cert was good, data was tampered with");
    }

    @Test
    public void testRawNoCandidateCred() throws SecurityException {
        this.rawCandidateCred = this.getCredential("foo-1A1-good.crt", "foo-1A1-good.key", new String[0]);
        this.rawSignature = XMLSigningUtil.signWithURI((Credential)this.rawCandidateCred, (String)this.rawAlgorithmURI, (byte[])this.rawSignedContent);
        this.rawCandidateCred = null;
        this.engine = this.getEngine(this.getCertificates("root1-ca.crt", "inter1A-ca.crt", "inter1A1-ca.crt"), EMPTY_CRLS, MAX_DEPTH, this.subjectCN);
        this.testRawValidateFailure("Entity cert was good, but candidate credential was not supplied to engine");
    }

    @Test
    public void testRawWrongCredType() throws SecurityException {
        this.rawCandidateCred = this.getCredential("foo-1A1-good.crt", "foo-1A1-good.key", new String[0]);
        this.rawSignature = XMLSigningUtil.signWithURI((Credential)this.rawCandidateCred, (String)this.rawAlgorithmURI, (byte[])this.rawSignedContent);
        PublicKey pubKey = this.rawCandidateCred.getPublicKey();
        assert (pubKey != null);
        this.rawCandidateCred = CredentialSupport.getSimpleCredential((PublicKey)pubKey, null);
        this.engine = this.getEngine(this.getCertificates("root1-ca.crt", "inter1A-ca.crt", "inter1A1-ca.crt"), EMPTY_CRLS, MAX_DEPTH, this.subjectCN);
        this.testRawValidateFailure("Entity cert was good, but candidate credential was not an X509Credential");
    }

    @Test
    public void testRawWhitelistedAlgorithm() throws SecurityException {
        HashSet<String> algos = new HashSet<String>();
        algos.add(this.rawAlgorithmURI);
        SignatureValidationParameters validationParams = new SignatureValidationParameters();
        validationParams.setIncludedAlgorithms(algos);
        this.criteriaSet.add((Object)new SignatureValidationParametersCriterion(validationParams));
        this.rawCandidateCred = this.getCredential("foo-1A1-good.crt", "foo-1A1-good.key", new String[0]);
        this.rawSignature = XMLSigningUtil.signWithURI((Credential)this.rawCandidateCred, (String)this.rawAlgorithmURI, (byte[])this.rawSignedContent);
        this.engine = this.getEngine(this.getCertificates("root1-ca.crt", "inter1A-ca.crt", "inter1A1-ca.crt"), EMPTY_CRLS, MAX_DEPTH, this.subjectCN);
        this.testRawValidateSuccess("Signature was valid with whitelisted algorithm");
    }

    @Test
    public void testRawBlacklistedAlgorithm() throws SecurityException {
        HashSet<String> algos = new HashSet<String>();
        algos.add(this.rawAlgorithmURI);
        SignatureValidationParameters validationParams = new SignatureValidationParameters();
        validationParams.setExcludedAlgorithms(algos);
        this.criteriaSet.add((Object)new SignatureValidationParametersCriterion(validationParams));
        this.rawCandidateCred = this.getCredential("foo-1A1-good.crt", "foo-1A1-good.key", new String[0]);
        this.rawSignature = XMLSigningUtil.signWithURI((Credential)this.rawCandidateCred, (String)this.rawAlgorithmURI, (byte[])this.rawSignedContent);
        this.engine = this.getEngine(this.getCertificates("root1-ca.crt", "inter1A-ca.crt", "inter1A1-ca.crt"), EMPTY_CRLS, MAX_DEPTH, this.subjectCN);
        this.testRawValidateFailure("Signature was invalid with blacklisted algorithm");
    }

    @Test(enabled=false)
    private void testValidateSuccess(String message) {
        try {
            if (!this.engine.validate(this.signature, this.criteriaSet)) {
                Assert.fail((String)("Evaluation of Signature failed, success was expected: " + message));
            }
        }
        catch (SecurityException e) {
            Assert.fail((String)("Evaluation failed due to processing exception: " + e.getMessage()));
        }
    }

    @Test(enabled=false)
    private void testValidateFailure(String message) {
        try {
            if (this.engine.validate(this.signature, this.criteriaSet)) {
                Assert.fail((String)("Evaluation of Signature succeeded, failure was expected: " + message));
            }
        }
        catch (SecurityException e) {
            Assert.fail((String)("Evaluation failed due to processing exception: " + e.getMessage()));
        }
    }

    @Nonnull
    private Signature getSignature(String entityCertFileName, String entityKeyFileName, String ... chainMembers) {
        BasicX509Credential cred = this.getCredential(entityCertFileName, entityKeyFileName, chainMembers);
        SignableXMLObject sxo = null;
        try {
            sxo = this.buildSignedObject((X509Credential)cred);
        }
        catch (SignatureException e) {
            Assert.fail((String)("Error building signed object: " + e.getMessage()));
        }
        assert (sxo != null);
        Element signedDOM = sxo.getDOM();
        assert (signedDOM != null);
        if (this.tamperDocumentPostSigning) {
            Element newChild = signedDOM.getOwnerDocument().createElementNS("http://www.example.org/testObjects", "test:SimpleElement");
            Text text = signedDOM.getOwnerDocument().createTextNode("HAHA, now you are tampered with");
            newChild.appendChild(text);
            signedDOM.insertBefore(newChild, signedDOM.getFirstChild());
        }
        SignableXMLObject verifiableSXO = null;
        try {
            verifiableSXO = (SignableXMLObject)unmarshallerFactory.ensureUnmarshaller(signedDOM).unmarshall(signedDOM);
        }
        catch (UnmarshallingException e) {
            Assert.fail((String)("Error unmarshalling new signed object: " + e.getMessage()));
        }
        assert (verifiableSXO != null);
        return (Signature)Constraint.isNotNull((Object)verifiableSXO.getSignature(), (String)"Signature was null");
    }

    private BasicX509Credential getCredential(String entityCertFileName, String entityKeyFileName, String ... chainMembers) {
        X509Certificate entityCert = this.getCertificate(entityCertFileName);
        assert (entityCert != null);
        BasicX509Credential cred = new BasicX509Credential(entityCert);
        PrivateKey privateKey = this.getPrivateKey(entityKeyFileName);
        cred.setPrivateKey(privateKey);
        HashSet<X509Certificate> certChain = new HashSet<X509Certificate>();
        certChain.add(entityCert);
        for (String member : chainMembers) {
            certChain.add(this.getCertificate(member));
        }
        cred.setEntityCertificateChain(certChain);
        return cred;
    }

    @Nonnull
    private PKIXSignatureTrustEngine getEngine(Collection<X509Certificate> certs, Collection<X509CRL> crls, Integer depth, String ... trustedNames) {
        PKIXValidationInformation info = this.getPKIXInfoSet(certs, crls, depth);
        ArrayList<PKIXValidationInformation> infoList = new ArrayList<PKIXValidationInformation>();
        infoList.add(info);
        HashSet<String> names = new HashSet<String>();
        for (String trustedName : trustedNames) {
            names.add(trustedName);
        }
        StaticPKIXValidationInformationResolver resolver = new StaticPKIXValidationInformationResolver(infoList, names);
        return new PKIXSignatureTrustEngine((PKIXValidationInformationResolver)resolver, XMLSecurityTestingSupport.buildBasicInlineKeyInfoResolver());
    }

    @Nonnull
    private PKIXValidationInformation getPKIXInfoSet(Collection<X509Certificate> certs, Collection<X509CRL> crls, Integer depth) {
        return new BasicPKIXValidationInformation(certs, crls, depth);
    }

    @Nonnull
    private Collection<X509Certificate> getCertificates(String ... certNames) {
        HashSet<X509Certificate> certs = new HashSet<X509Certificate>();
        for (String certName : certNames) {
            certs.add(this.getCertificate(certName));
        }
        return certs;
    }

    private PrivateKey getPrivateKey(String fileName) {
        try {
            InputStream ins = this.getInputStream(fileName);
            byte[] encoded = new byte[ins.available()];
            ins.read(encoded);
            return KeySupport.decodePrivateKey((byte[])encoded, null);
        }
        catch (Exception e) {
            Assert.fail((String)("Could not create private key from file: " + fileName + ": " + e.getMessage()));
            return null;
        }
    }

    @Nullable
    private X509Certificate getCertificate(String fileName) {
        try {
            InputStream ins = this.getInputStream(fileName);
            byte[] encoded = new byte[ins.available()];
            ins.read(encoded);
            return (X509Certificate)X509Support.decodeCertificates((byte[])encoded).iterator().next();
        }
        catch (Exception e) {
            Assert.fail((String)("Could not create certificate from file: " + fileName + ": " + e.getMessage()));
            return null;
        }
    }

    @Nonnull
    private Collection<X509CRL> getCRLS(String ... crlNames) {
        HashSet<X509CRL> crls = new HashSet<X509CRL>();
        for (String crlName : crlNames) {
            crls.add(this.getCRL(crlName));
        }
        return crls;
    }

    @Nullable
    private X509CRL getCRL(String fileName) {
        try {
            InputStream ins = this.getInputStream(fileName);
            byte[] encoded = new byte[ins.available()];
            ins.read(encoded);
            return (X509CRL)X509Support.decodeCRLs((byte[])encoded).iterator().next();
        }
        catch (Exception e) {
            Assert.fail((String)("Could not create CRL from file: " + fileName + ": " + e.getMessage()));
            return null;
        }
    }

    @Nonnull
    private InputStream getInputStream(String fileName) {
        return PKIXSignatureTrustEngineTest.class.getResourceAsStream(DATA_PATH + fileName);
    }

    @Nonnull
    private SignableXMLObject buildSignedObject(X509Credential signingX509Cred) throws SignatureException {
        SignableSimpleXMLObject sxo = (SignableSimpleXMLObject)this.buildXMLObject(SignableSimpleXMLObject.ELEMENT_NAME);
        sxo.setId("abc123");
        SignableSimpleXMLObject child = (SignableSimpleXMLObject)this.buildXMLObject(SignableSimpleXMLObject.ELEMENT_NAME);
        child.setValue("SomeSimpleValueAsTextContent");
        sxo.getSimpleXMLObjects().add(child);
        Signature sig = (Signature)this.buildXMLObject(Signature.DEFAULT_ELEMENT_NAME);
        sig.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        sig.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        sig.setSigningCredential((Credential)signingX509Cred);
        String id = sxo.getId();
        assert (id != null);
        DocumentInternalIDContentReference idContentRef = new DocumentInternalIDContentReference(id);
        idContentRef.setDigestAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");
        idContentRef.getTransforms().add("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        idContentRef.getTransforms().add("http://www.w3.org/2001/10/xml-exc-c14n#");
        sig.getContentReferences().add(idContentRef);
        if (this.emitKeyInfo) {
            X509KeyInfoGeneratorFactory kiFactory = new X509KeyInfoGeneratorFactory();
            if (this.emitKeyValueOnly) {
                kiFactory.setEmitPublicKeyValue(true);
            } else {
                kiFactory.setEmitEntityCertificate(true);
                kiFactory.setEmitEntityCertificateChain(true);
                kiFactory.setEmitX509SubjectName(true);
            }
            KeyInfo keyInfo = null;
            try {
                keyInfo = kiFactory.newInstance().generate((Credential)signingX509Cred);
            }
            catch (SecurityException e) {
                Assert.fail((String)("Error generating KeyInfo from signing credential: " + e));
            }
            sig.setKeyInfo(keyInfo);
        }
        sxo.setSignature(sig);
        try {
            XMLObjectProviderRegistrySupport.getMarshallerFactory().ensureMarshaller((XMLObject)sxo).marshall((XMLObject)sxo);
        }
        catch (MarshallingException e) {
            Assert.fail((String)("Error marshalling object for signing: " + e));
        }
        Signer.signObject((Signature)sig);
        return sxo;
    }

    @Test(enabled=false)
    private void testRawValidateSuccess(String message) {
        try {
            if (!this.engine.validate(this.rawSignature, this.rawSignedContent, this.rawAlgorithmURI, this.criteriaSet, this.rawCandidateCred)) {
                Assert.fail((String)("Evaluation of Signature failed, success was expected: " + message));
            }
        }
        catch (SecurityException e) {
            Assert.fail((String)("Evaluation failed due to processing exception: " + e.getMessage()));
        }
    }

    @Test(enabled=false)
    private void testRawValidateFailure(String message) {
        try {
            if (this.engine.validate(this.rawSignature, this.rawSignedContent, this.rawAlgorithmURI, this.criteriaSet, this.rawCandidateCred)) {
                Assert.fail((String)("Evaluation of Signature succeeded, failure was expected: " + message));
            }
        }
        catch (SecurityException e) {
            Assert.fail((String)("Evaluation failed due to processing exception: " + e.getMessage()));
        }
    }
}

