/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.support.tests;

import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.annotation.Nonnull;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.SerializeSupport;
import net.shibboleth.shared.xml.XMLParserException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.mock.SignableSimpleXMLObject;
import org.opensaml.xmlsec.mock.SignableSimpleXMLObjectBuilder;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.DocumentInternalIDContentReference;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureValidator;
import org.opensaml.xmlsec.signature.support.Signer;
import org.slf4j.Logger;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EnvelopedSignatureTest
extends XMLObjectBaseTestCase {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(EnvelopedSignatureTest.class);
    private Credential goodCredential;
    private Credential badCredential;
    private SignableSimpleXMLObjectBuilder sxoBuilder;
    private XMLObjectBuilder<Signature> sigBuilder;
    private String algoURI = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";

    @BeforeMethod
    protected void setUp() throws Exception {
        KeyPair keyPair = KeySupport.generateKeyPair((String)"RSA", (int)1024, null);
        this.goodCredential = CredentialSupport.getSimpleCredential((PublicKey)keyPair.getPublic(), (PrivateKey)keyPair.getPrivate());
        keyPair = KeySupport.generateKeyPair((String)"RSA", (int)1024, null);
        this.badCredential = CredentialSupport.getSimpleCredential((PublicKey)keyPair.getPublic(), null);
        this.sxoBuilder = new SignableSimpleXMLObjectBuilder();
        this.sigBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(Signature.DEFAULT_ELEMENT_NAME);
    }

    @Test
    public void testSigningAndVerification() throws MarshallingException, SignatureException {
        SignableSimpleXMLObject sxo = this.getXMLObjectWithSignature();
        Signature signature = sxo.getSignature();
        Marshaller marshaller = XMLObjectProviderRegistrySupport.getMarshallerFactory().ensureMarshaller((XMLObject)sxo);
        Element signedElement = marshaller.marshall((XMLObject)sxo);
        assert (signature != null);
        Signer.signObject((Signature)signature);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Marshalled Signature: \n" + SerializeSupport.nodeToString((Node)signedElement));
        }
        SignatureValidator.validate((Signature)signature, (Credential)this.goodCredential);
        try {
            SignatureValidator.validate((Signature)signature, (Credential)this.badCredential);
            Assert.fail((String)"Validated signature with improper public key");
        }
        catch (SignatureException signatureException) {
            // empty catch block
        }
    }

    @Test
    public void testUnmarshall() throws XMLParserException, UnmarshallingException, GeneralSecurityException {
        String envelopedSignatureFile = "/org/opensaml/xmlsec/signature/support/envelopedSignature.xml";
        InputStream ins = EnvelopedSignatureTest.class.getResourceAsStream(envelopedSignatureFile);
        Document envelopedSignatureDoc = parserPool.parse(ins);
        Element rootElement = envelopedSignatureDoc.getDocumentElement();
        Unmarshaller unmarshaller = XMLObjectProviderRegistrySupport.getUnmarshallerFactory().ensureUnmarshaller(rootElement);
        SignableSimpleXMLObject sxo = (SignableSimpleXMLObject)unmarshaller.unmarshall(rootElement);
        Assert.assertEquals((String)sxo.getId(), (String)"FOO", (String)"Id attribute was not expected value");
        Signature signature = sxo.getSignature();
        assert (signature != null);
        KeyInfo keyInfo = signature.getKeyInfo();
        Assert.assertNotNull((Object)keyInfo, (String)"Signature's KeyInfo was null");
        PublicKey pubKey = (PublicKey)KeyInfoSupport.getPublicKeys((KeyInfo)keyInfo).get(0);
        Assert.assertNotNull((Object)pubKey, (String)"KeyInfo did not contain the verification key");
    }

    private SignableSimpleXMLObject getXMLObjectWithSignature() {
        SignableSimpleXMLObject sxo = this.sxoBuilder.buildObject();
        sxo.setId("FOO");
        Signature sig = (Signature)this.sigBuilder.buildObject(Signature.DEFAULT_ELEMENT_NAME);
        sig.setSigningCredential(this.goodCredential);
        sig.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        sig.setSignatureAlgorithm(this.algoURI);
        DocumentInternalIDContentReference contentReference = new DocumentInternalIDContentReference("FOO");
        contentReference.getTransforms().add("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        contentReference.getTransforms().add("http://www.w3.org/2001/10/xml-exc-c14n#");
        contentReference.setDigestAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");
        sig.getContentReferences().add(contentReference);
        sxo.setSignature(sig);
        return sxo;
    }
}

