/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.support.tests;

import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.List;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureSupport;
import org.opensaml.xmlsec.signature.support.URIContentReference;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class SignatureSupportTest
extends XMLObjectBaseTestCase {
    private Credential signingCredential;
    private KeyInfoGenerator keyInfoGenerator;

    @BeforeClass
    public void initializeKeyPairAndGenerator() throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPair keyPair = KeySupport.generateKeyPair((String)"RSA", (int)1024, null);
        this.signingCredential = CredentialSupport.getSimpleCredential((PublicKey)keyPair.getPublic(), (PrivateKey)keyPair.getPrivate());
        KeyInfoGeneratorFactory factory = DefaultSecurityConfigurationBootstrap.buildBasicKeyInfoGeneratorManager().getDefaultManager().getFactory(this.signingCredential);
        assert (factory != null);
        this.keyInfoGenerator = factory.newInstance();
    }

    @Test
    public void testBasic() throws SecurityException {
        Signature signature = this.buildTemplateSignature();
        SignatureSigningParameters params = this.buildTemplateSigningParameters();
        SignatureSupport.prepareSignatureParams((Signature)signature, (SignatureSigningParameters)params);
        Assert.assertNotNull((Object)signature.getCanonicalizationAlgorithm());
        Assert.assertNotNull((Object)signature.getSignatureAlgorithm());
        Assert.assertNotNull((Object)signature.getSigningCredential());
        Assert.assertNotNull((Object)signature.getKeyInfo());
        URIContentReference cr = (URIContentReference)signature.getContentReferences().get(0);
        Assert.assertNotNull((Object)cr);
        Assert.assertEquals((String)cr.getDigestAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#sha512");
        Assert.assertTrue((boolean)cr.getTransforms().isEmpty());
    }

    @Test
    public void testAddReferenceCanonicalizationTransformAlone() throws SecurityException {
        Signature signature = this.buildTemplateSignature();
        SignatureSigningParameters params = this.buildTemplateSigningParameters();
        params.setSignatureReferenceCanonicalizationAlgorithm("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        SignatureSupport.prepareSignatureParams((Signature)signature, (SignatureSigningParameters)params);
        URIContentReference cr = (URIContentReference)signature.getContentReferences().get(0);
        Assert.assertNotNull((Object)cr);
        Assert.assertEquals((int)cr.getTransforms().size(), (int)1);
        Assert.assertEquals((String)((String)cr.getTransforms().get(0)), (String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
    }

    @Test
    public void testAddReferenceCanonicalizationTransformAfterEnveloped() throws SecurityException {
        Signature signature = this.buildTemplateSignature();
        List transforms = ((URIContentReference)signature.getContentReferences().get(0)).getTransforms();
        transforms.add("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        SignatureSigningParameters params = this.buildTemplateSigningParameters();
        params.setSignatureReferenceCanonicalizationAlgorithm("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        SignatureSupport.prepareSignatureParams((Signature)signature, (SignatureSigningParameters)params);
        URIContentReference cr = (URIContentReference)signature.getContentReferences().get(0);
        Assert.assertNotNull((Object)cr);
        Assert.assertEquals((int)cr.getTransforms().size(), (int)2);
        Assert.assertEquals((String)((String)cr.getTransforms().get(1)), (String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
    }

    @Test
    public void testReplaceReferenceCanonicalizationTransformAlone() throws SecurityException {
        Signature signature = this.buildTemplateSignature();
        List transforms = ((URIContentReference)signature.getContentReferences().get(0)).getTransforms();
        transforms.add("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        SignatureSigningParameters params = this.buildTemplateSigningParameters();
        params.setSignatureReferenceCanonicalizationAlgorithm("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        SignatureSupport.prepareSignatureParams((Signature)signature, (SignatureSigningParameters)params);
        URIContentReference cr = (URIContentReference)signature.getContentReferences().get(0);
        Assert.assertNotNull((Object)cr);
        Assert.assertEquals((int)cr.getTransforms().size(), (int)1);
        Assert.assertEquals((String)((String)cr.getTransforms().get(0)), (String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
    }

    @Test
    public void testReplaceReferenceCanonicalizationTransformAfterEnveloped() throws SecurityException {
        Signature signature = this.buildTemplateSignature();
        List transforms = ((URIContentReference)signature.getContentReferences().get(0)).getTransforms();
        transforms.add("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        transforms.add("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        SignatureSigningParameters params = this.buildTemplateSigningParameters();
        params.setSignatureReferenceCanonicalizationAlgorithm("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        SignatureSupport.prepareSignatureParams((Signature)signature, (SignatureSigningParameters)params);
        URIContentReference cr = (URIContentReference)signature.getContentReferences().get(0);
        Assert.assertNotNull((Object)cr);
        Assert.assertEquals((int)cr.getTransforms().size(), (int)2);
        Assert.assertEquals((String)((String)cr.getTransforms().get(1)), (String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
    }

    private Signature buildTemplateSignature() {
        Signature signature = (Signature)this.buildXMLObject(Signature.DEFAULT_ELEMENT_NAME);
        URIContentReference cr = new URIContentReference("abc123");
        signature.getContentReferences().add(cr);
        return signature;
    }

    private SignatureSigningParameters buildTemplateSigningParameters() {
        SignatureSigningParameters params = new SignatureSigningParameters();
        params.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        params.setSignatureCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        params.setSignatureReferenceDigestMethod("http://www.w3.org/2001/04/xmlenc#sha512");
        params.setSigningCredential(this.signingCredential);
        params.setKeyInfoGenerator(this.keyInfoGenerator);
        return params;
    }
}

