/*
 * Copyright [2007] [University Corporation for Advanced Internet Development, Inc.]
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opensaml.xml.signature.validator;

import org.opensaml.xml.signature.RSAKeyValue;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

/**
 * Checks {@link org.opensaml.xml.signature.RSAKeyValue} for Schema compliance. 
 */
public class RSAKeyValueSchemaValidator implements Validator<RSAKeyValue> {

    /** {@inheritDoc} */
    public void validate(RSAKeyValue xmlObject) throws ValidationException {
        validateChildrenPresence(xmlObject);
    }

    /**
     * Validate that all children are present.
     * 
     * @param xmlObject the object to validate
     * @throws ValidationException  thrown if the object is invalid
     */
    protected void validateChildrenPresence(RSAKeyValue xmlObject) throws ValidationException {
        if (xmlObject.getModulus() == null) {
            throw new ValidationException("RSAKeyValue did not contain a required Modulus value");
        }
        if (xmlObject.getExponent() == null) {
            throw new ValidationException("RSAKeyValue did not contain a required Exponent value");
        }
    }
}
