/*
 * Decompiled with CFR 0.152.
 */
package org.cts.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class AngleFormat {
    private static double DEG_TO_MIN = 60.0;
    private static double DEG_TO_SEC = 3600.0;
    private static final int PREFIX = 1;
    private static final int DEGREE_FORMAT = 2;
    private static final int DEGREE_SUFFIX = 3;
    private static final int MINUTE_FORMAT = 4;
    private static final int MINUTE_SUFFIX = 5;
    private static final int SECOND_FORMAT = 6;
    private static final int SECOND_SUFFIX = 7;
    private static final int HEMISPHERE = 8;
    private static final int POSITIVE_SUFFIX = 9;
    private static final int NEGATIVE_SUFFIX = 10;
    private static final Pattern DMSHFormatPattern = Pattern.compile("(?:([^#DMS]*))(?:(#?D+(?:\\.D+)?)([^#.MSH]*))(?:(#?M+(?:\\.M+)?)([^#.DSH]*))?(?:(#?S+(?:\\.S+)?)([^#.DMH]*))?(H\\((\\w+)\\|(\\w+)\\))?");
    private static final int SIGNUM = 1;
    private static final int DEGREE_VALUE = 2;
    private static final int DEGREE_UNIT = 3;
    private static final int MINUTE_VALUE = 4;
    private static final int MINUTE_UNIT = 5;
    private static final int SECOND_VALUE = 6;
    private static final int SECOND_UNIT = 7;
    private static final Pattern DMSHFormat = Pattern.compile("[^\\d+\\-.]*([+\\-])?[\\s]*([\\d]+(?:[.,]\\d*)?|[.,]\\d+)[\\s]*(?:\u00b0|([dDgG])[a-zA-Z]*\\.?)?[\\s]*([\\d]+(?:[.,]\\d*)?)?[\\s]*(?:'|([mM])[a-zA-Z]*\\.?)?[\\s]*([\\d]+(?:[.,]\\d*)?)?[\\s]*(?:\"|([sS])[a-zA-Z]*\\.?)?[\\s]*([NSEWOnsewo])?.*");
    private String prefix = null;
    private DecimalFormat degree_format = new DecimalFormat("#0");
    private String degree_suffix = "\u00b0 ";
    private DecimalFormat minute_format = new DecimalFormat("00");
    private String minute_suffix = "' ";
    private DecimalFormat second_format = new DecimalFormat("00.000");
    private String second_suffix = "\" ";
    private boolean suffix = true;
    private String positive_suffix = "N";
    private String negative_suffix = "S";
    public static final AngleFormat LONGITUDE_FORMATTER = new AngleFormat("#D\u00b0 MM' SS.SSSSS\" H(E|W)");
    public static final AngleFormat LATITUDE_FORMATTER = new AngleFormat("#D\u00b0 MM' SS.SSSSS\" H(N|S)");

    public static double rad2deg(double angle) {
        return angle * 180.0 / Math.PI;
    }

    public static double rad2gra(double angle) {
        return angle * 200.0 / Math.PI;
    }

    public static double rad2min(double angle) {
        return angle * 10800.0 / Math.PI;
    }

    public static double rad2sec(double angle) {
        return angle * 648000.0 / Math.PI;
    }

    public static double deg2rad(double angle) {
        return angle * Math.PI / 180.0;
    }

    public static double deg2gra(double angle) {
        return angle * 200.0 / 180.0;
    }

    public static double deg2min(double angle) {
        return angle * DEG_TO_MIN;
    }

    public static double deg2sec(double angle) {
        return angle * DEG_TO_SEC;
    }

    public static double gra2rad(double angle) {
        return angle * Math.PI / 200.0;
    }

    public static double gra2deg(double angle) {
        return angle * 180.0 / 200.0;
    }

    public static double dms2dd(double dmsAngle) {
        double sign = Math.signum(dmsAngle);
        double dd = Math.floor(Math.abs(dmsAngle));
        double mm = Math.floor(100.0 * (Math.abs(dmsAngle) - dd));
        double ss = 10000.0 * (Math.abs(dmsAngle) - dd - mm / 100.0);
        return sign * (dd + mm / DEG_TO_MIN + ss / DEG_TO_SEC);
    }

    public static double dd2dms(double ddAngle) {
        double sign = Math.signum(ddAngle);
        double dd = Math.floor(Math.abs(ddAngle));
        double mm = Math.floor(DEG_TO_MIN * (Math.abs(ddAngle) - dd));
        double ss = DEG_TO_SEC * (Math.abs(ddAngle) - dd - mm / DEG_TO_MIN);
        return sign * (dd + mm / 100.0 + ss / 10000.0);
    }

    public AngleFormat() {
        this.degree_format.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.ENGLISH));
        this.minute_format.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.ENGLISH));
        this.second_format.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.ENGLISH));
    }

    public AngleFormat(String pattern) throws IllegalArgumentException {
        if (pattern == null) {
            throw new IllegalArgumentException("The pattern should not be null.");
        }
        Matcher matcher = DMSHFormatPattern.matcher(pattern);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(pattern + " is an illegal pattern for an AngleFormat.");
        }
        this.prefix = matcher.group(1);
        this.degree_format = new DecimalFormat(matcher.group(2).replaceAll("D", "0"));
        this.degree_format.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.ENGLISH));
        this.degree_suffix = matcher.group(3);
        if (null == matcher.group(4)) {
            this.minute_format = null;
        } else {
            this.minute_format = new DecimalFormat(matcher.group(4).replaceAll("M", "0"));
            this.minute_format.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.ENGLISH));
        }
        this.minute_suffix = null == matcher.group(5) ? "" : matcher.group(5);
        if (null == matcher.group(6)) {
            this.second_format = null;
        } else {
            this.second_format = new DecimalFormat(matcher.group(6).replaceAll("S", "0"));
            this.second_format.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.ENGLISH));
        }
        this.second_suffix = null == matcher.group(7) ? "" : matcher.group(7);
        if (null != matcher.group(8)) {
            this.positive_suffix = matcher.group(9);
            this.negative_suffix = matcher.group(10);
        } else {
            this.suffix = false;
        }
    }

    public String format(double angle) {
        double absAngle = Math.abs(angle);
        StringBuilder sb = new StringBuilder();
        if (this.prefix != null) {
            sb.append(this.prefix);
        }
        if (!this.suffix) {
            sb.append(angle < 0.0 ? "-" : "+");
        }
        if (this.minute_format == null) {
            sb.append(this.degree_format.format(absAngle));
        } else {
            sb.append(this.degree_format.format(Math.floor(absAngle)));
        }
        sb.append(this.degree_suffix);
        if (this.degree_suffix.length() == 0) {
            sb.append(" ");
        }
        if (this.minute_format != null) {
            double minutes = AngleFormat.deg2min(absAngle) % DEG_TO_MIN;
            if (this.second_format == null) {
                sb.append(this.minute_format.format(minutes));
            } else {
                sb.append(this.minute_format.format(Math.floor(minutes)));
            }
            sb.append(this.minute_suffix);
            if (this.minute_suffix.length() == 0) {
                sb.append(" ");
            }
            if (this.second_format != null) {
                double seconds = AngleFormat.deg2sec(absAngle) % DEG_TO_MIN;
                sb.append(this.second_format.format(seconds)).append(this.second_suffix);
            }
        }
        if (this.suffix) {
            if (angle >= 0.0) {
                sb.append(this.positive_suffix);
            } else {
                sb.append(this.negative_suffix);
            }
        }
        return sb.toString();
    }

    public static double parseAngle(String angle) throws IllegalArgumentException {
        Matcher m = DMSHFormat.matcher(angle);
        if (m.matches()) {
            double degrees = Double.parseDouble(m.group(2));
            String deg = m.group(3);
            double minutes = m.group(4) == null ? 0.0 : Double.parseDouble(m.group(4));
            String min = m.group(5);
            double seconds = m.group(6) == null ? 0.0 : Double.parseDouble(m.group(6));
            String sec = m.group(7);
            double a = degrees + minutes / DEG_TO_MIN + seconds / DEG_TO_SEC;
            String signum = m.group(1);
            if ("-".equals(signum)) {
                return -a;
            }
            String h = m.group(8);
            if (h != null && h.matches("[SsOoWw].*")) {
                return -a;
            }
            if (sec != null && deg == null && min == null) {
                return -a;
            }
            return a;
        }
        throw new IllegalArgumentException(angle + " is not a recognized angle value.");
    }

    public static double parseAndConvert2Radians(String angle) throws IllegalArgumentException {
        if (angle == null) {
            throw new IllegalArgumentException("The angle should not be null.");
        }
        if (angle.matches("[+\\-]?([0-9]+([.,][0-9]+)|[.][0-9]+)")) {
            String formatted = angle.replaceAll(",", ".");
            return Double.parseDouble(formatted);
        }
        if (angle.matches("(?i).*(g|g\\.|gr|gr\\.|grad|grad\\.|grades)\\z")) {
            String formatted = angle.replaceAll("(?i)[\\s]*(g|g\\.|gr|gr\\.|grad|grad\\.|grades)\\z", "");
            formatted = formatted.replaceAll(",", ".");
            return AngleFormat.gra2rad(Double.parseDouble(formatted));
        }
        double d = AngleFormat.parseAngle(angle);
        return AngleFormat.deg2rad(d);
    }
}

