/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean.ext;

import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.resource.visitor.dom.DOMVisitBefore;
import org.w3c.dom.Element;

public class WireOnElementChecker
implements DOMVisitBefore {
    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        if (!this.isCreateOnElementSet(element) && !this.isWireOnElementSet(element)) {
            throw new SmooksConfigException("The bindings attribute 'createOnElement' and wiring attribute 'wireOnElement' are both not set. One of them must at least be set. If the result of this binding should be a new populated Object then you need to set the 'createOnElement' bindings attribute. If you want to update an existing object in the bean context then you must set the 'wireOnElement' attribute.");
        }
    }

    protected boolean isCreateOnElementSet(Element element) {
        String createOnElement = ((Element)element.getParentNode()).getAttribute("createOnElement");
        return !createOnElement.isEmpty();
    }

    protected boolean isWireOnElementSet(Element element) {
        String wireOnElement = element.getAttribute("wireOnElement");
        return !wireOnElement.isEmpty();
    }
}

