/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.commons;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.EnvironmentPostProcessor;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.properties.bind.BindContext;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.core.Ordered;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public abstract class ConfigDataMissingEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    public static final String CONFIG_IMPORT_PROPERTY = "spring.config.import";
    private static final Bindable<String[]> CONFIG_DATA_LOCATION_ARRAY = Bindable.of(String[].class);
    private static final String[] EMPTY_ARRAY = new String[0];
    public static final int ORDER = -2147482638;
    private final Logger LOG = LoggerFactory.getLogger(ConfigDataMissingEnvironmentPostProcessor.class);

    public int getOrder() {
        return -2147482638;
    }

    protected abstract boolean shouldProcessEnvironment(Environment var1);

    protected abstract String getPrefix();

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (!this.shouldProcessEnvironment((Environment)environment)) {
            return;
        }
        List<Object> property = this.getConfigImports(environment);
        if (property == null || property.isEmpty()) {
            throw new ImportException("No spring.config.import set", false);
        }
        if (!property.stream().anyMatch(impt -> ((String)impt).contains(this.getPrefix()))) {
            throw new ImportException("spring.config.import missing " + this.getPrefix(), true);
        }
    }

    private List<Object> getConfigImports(ConfigurableEnvironment environment) {
        MutablePropertySources propertySources = environment.getPropertySources();
        List<Object> property = propertySources.stream().filter(this::propertySourceWithConfigImport).flatMap(propertySource -> {
            ArrayList<Object> configImports = new ArrayList<Object>();
            if (propertySource.getProperty(CONFIG_IMPORT_PROPERTY) != null) {
                configImports.add(propertySource.getProperty(CONFIG_IMPORT_PROPERTY));
            } else {
                configImports.addAll(Arrays.asList(this.getConfigImportArray((PropertySource)propertySource)));
            }
            return configImports.stream();
        }).collect(Collectors.toList());
        return property;
    }

    private boolean propertySourceWithConfigImport(PropertySource propertySource) {
        if (propertySource instanceof CompositePropertySource) {
            return ((CompositePropertySource)propertySource).getPropertySources().stream().anyMatch(this::propertySourceWithConfigImport);
        }
        return propertySource.containsProperty(CONFIG_IMPORT_PROPERTY) || this.getConfigImportArray(propertySource).length > 0;
    }

    private String[] getConfigImportArray(PropertySource propertySource) {
        ConfigurationPropertySource configurationPropertySource = ConfigurationPropertySource.from((PropertySource)propertySource);
        if (configurationPropertySource == null) {
            return EMPTY_ARRAY;
        }
        Binder binder = new Binder(new ConfigurationPropertySource[]{configurationPropertySource});
        return (String[])binder.bind(CONFIG_IMPORT_PROPERTY, CONFIG_DATA_LOCATION_ARRAY, new BindHandler(){

            public Object onFailure(ConfigurationPropertyName name, Bindable<?> target, BindContext context, Exception error) throws Exception {
                ConfigDataMissingEnvironmentPostProcessor.this.LOG.info("Error binding spring.config.import", (Throwable)error);
                return EMPTY_ARRAY;
            }
        }).orElse((Object)EMPTY_ARRAY);
    }

    public static class ImportException
    extends RuntimeException {
        public final boolean missingPrefix;

        ImportException(String message, boolean missingPrefix) {
            super(message);
            this.missingPrefix = missingPrefix;
        }
    }
}

