/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers;

import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.web.server.ServerWebExchange;

public interface HttpHeadersFilter {
    public static HttpHeaders filterRequest(List<HttpHeadersFilter> filters, ServerWebExchange exchange) {
        HttpHeaders headers = exchange.getRequest().getHeaders();
        return HttpHeadersFilter.filter(filters, headers, exchange, Type.REQUEST);
    }

    public static HttpHeaders filter(List<HttpHeadersFilter> filters, HttpHeaders input, ServerWebExchange exchange, Type type) {
        if (filters != null) {
            HttpHeaders filtered = input;
            for (int i = 0; i < filters.size(); ++i) {
                HttpHeadersFilter filter = filters.get(i);
                if (!filter.supports(type)) continue;
                filtered = filter.filter(filtered, exchange);
            }
            return filtered;
        }
        return input;
    }

    public HttpHeaders filter(HttpHeaders var1, ServerWebExchange var2);

    default public boolean supports(Type type) {
        return type.equals((Object)Type.REQUEST);
    }

    public static enum Type {
        REQUEST,
        RESPONSE;

    }
}

