/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.jdbc;

import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class SpanNameProvider {
    private static final String DEFAULT_SPAN_NAME = "query";
    private static final Pattern PATTERN_MATCHING_FIRST_WORD_OF_SQL = Pattern.compile("^([a-zA-Z]+)[^a-zA-Z]?.*$");

    SpanNameProvider() {
    }

    String getSpanNameFor(String sql) {
        String spanName = DEFAULT_SPAN_NAME;
        if (!Objects.isNull(sql)) {
            spanName = this.getSpanNameForNonNull(sql);
        }
        return spanName;
    }

    private String getSpanNameForNonNull(String sql) {
        String spanName = DEFAULT_SPAN_NAME;
        Matcher matcher = PATTERN_MATCHING_FIRST_WORD_OF_SQL.matcher(sql);
        if (matcher.matches()) {
            spanName = matcher.group(1).toLowerCase(Locale.ROOT);
        }
        return spanName;
    }
}

