/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.batch;

import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.batch.TraceJobExecutionListener;

public class TraceJobBuilderFactory
extends JobBuilderFactory {
    private final BeanFactory beanFactory;
    private final JobBuilderFactory delegate;
    private Tracer tracer;

    public TraceJobBuilderFactory(BeanFactory beanFactory, JobBuilderFactory delegate) {
        super(null);
        this.beanFactory = beanFactory;
        this.delegate = delegate;
    }

    public JobBuilder get(String name) {
        return (JobBuilder)this.delegate.get(name).listener((JobExecutionListener)new TraceJobExecutionListener(this.tracer()));
    }

    private Tracer tracer() {
        if (this.tracer == null) {
            this.tracer = (Tracer)this.beanFactory.getBean(Tracer.class);
        }
        return this.tracer;
    }
}

