/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.builders;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.core.OrderComparator;
import org.springframework.core.Ordered;
import org.springframework.core.ResolvableType;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.ObjectPostProcessor;
import org.springframework.security.config.annotation.AbstractConfiguredSecurityBuilder;
import org.springframework.security.config.annotation.SecurityBuilder;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.AbstractRequestMatcherRegistry;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.builders.FilterOrderRegistration;
import org.springframework.security.config.annotation.web.configurers.AnonymousConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.config.annotation.web.configurers.CorsConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.annotation.web.configurers.HttpBasicConfigurer;
import org.springframework.security.config.annotation.web.configurers.HttpsRedirectConfigurer;
import org.springframework.security.config.annotation.web.configurers.JeeConfigurer;
import org.springframework.security.config.annotation.web.configurers.LogoutConfigurer;
import org.springframework.security.config.annotation.web.configurers.PasswordManagementConfigurer;
import org.springframework.security.config.annotation.web.configurers.PortMapperConfigurer;
import org.springframework.security.config.annotation.web.configurers.RememberMeConfigurer;
import org.springframework.security.config.annotation.web.configurers.RequestCacheConfigurer;
import org.springframework.security.config.annotation.web.configurers.SecurityContextConfigurer;
import org.springframework.security.config.annotation.web.configurers.ServletApiConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.annotation.web.configurers.WebAuthnConfigurer;
import org.springframework.security.config.annotation.web.configurers.X509Configurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2ClientConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2LoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OidcLogoutConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2AuthorizationServerConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.resource.OAuth2ResourceServerConfigurer;
import org.springframework.security.config.annotation.web.configurers.ott.OneTimeTokenLoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.saml2.Saml2LoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.saml2.Saml2LogoutConfigurer;
import org.springframework.security.config.annotation.web.configurers.saml2.Saml2MetadataConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class HttpSecurity
extends AbstractConfiguredSecurityBuilder<DefaultSecurityFilterChain, HttpSecurity>
implements SecurityBuilder<DefaultSecurityFilterChain>,
HttpSecurityBuilder<HttpSecurity> {
    private final RequestMatcherConfigurer requestMatcherConfigurer;
    private List<OrderedFilter> filters = new ArrayList<OrderedFilter>();
    private RequestMatcher requestMatcher = AnyRequestMatcher.INSTANCE;
    private FilterOrderRegistration filterOrders = new FilterOrderRegistration();
    private AuthenticationManager authenticationManager;

    public HttpSecurity(ObjectPostProcessor<Object> objectPostProcessor, AuthenticationManagerBuilder authenticationBuilder, Map<Class<?>, Object> sharedObjects) {
        super(objectPostProcessor);
        Assert.notNull((Object)authenticationBuilder, (String)"authenticationBuilder cannot be null");
        this.setSharedObject(AuthenticationManagerBuilder.class, authenticationBuilder);
        for (Map.Entry<Class<?>, Object> entry : sharedObjects.entrySet()) {
            this.setSharedObject(entry.getKey(), entry.getValue());
        }
        ApplicationContext context = (ApplicationContext)sharedObjects.get(ApplicationContext.class);
        this.requestMatcherConfigurer = new RequestMatcherConfigurer(context);
    }

    private ApplicationContext getContext() {
        return this.getSharedObject(ApplicationContext.class);
    }

    public HttpSecurity headers(Customizer<HeadersConfigurer<HttpSecurity>> headersCustomizer) throws Exception {
        headersCustomizer.customize(this.getOrApply(new HeadersConfigurer()));
        return this;
    }

    public HttpSecurity cors(Customizer<CorsConfigurer<HttpSecurity>> corsCustomizer) throws Exception {
        corsCustomizer.customize(this.getOrApply(new CorsConfigurer()));
        return this;
    }

    public HttpSecurity sessionManagement(Customizer<SessionManagementConfigurer<HttpSecurity>> sessionManagementCustomizer) throws Exception {
        sessionManagementCustomizer.customize(this.getOrApply(new SessionManagementConfigurer()));
        return this;
    }

    public HttpSecurity portMapper(Customizer<PortMapperConfigurer<HttpSecurity>> portMapperCustomizer) throws Exception {
        portMapperCustomizer.customize(this.getOrApply(new PortMapperConfigurer()));
        return this;
    }

    public HttpSecurity jee(Customizer<JeeConfigurer<HttpSecurity>> jeeCustomizer) throws Exception {
        jeeCustomizer.customize(this.getOrApply(new JeeConfigurer()));
        return this;
    }

    public HttpSecurity x509(Customizer<X509Configurer<HttpSecurity>> x509Customizer) throws Exception {
        x509Customizer.customize(this.getOrApply(new X509Configurer()));
        return this;
    }

    public HttpSecurity rememberMe(Customizer<RememberMeConfigurer<HttpSecurity>> rememberMeCustomizer) throws Exception {
        rememberMeCustomizer.customize(this.getOrApply(new RememberMeConfigurer()));
        return this;
    }

    public HttpSecurity authorizeHttpRequests(Customizer<AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry> authorizeHttpRequestsCustomizer) throws Exception {
        ApplicationContext context = this.getContext();
        authorizeHttpRequestsCustomizer.customize(this.getOrApply(new AuthorizeHttpRequestsConfigurer(context)).getRegistry());
        return this;
    }

    public HttpSecurity requestCache(Customizer<RequestCacheConfigurer<HttpSecurity>> requestCacheCustomizer) throws Exception {
        requestCacheCustomizer.customize(this.getOrApply(new RequestCacheConfigurer()));
        return this;
    }

    public HttpSecurity exceptionHandling(Customizer<ExceptionHandlingConfigurer<HttpSecurity>> exceptionHandlingCustomizer) throws Exception {
        exceptionHandlingCustomizer.customize(this.getOrApply(new ExceptionHandlingConfigurer()));
        return this;
    }

    public HttpSecurity securityContext(Customizer<SecurityContextConfigurer<HttpSecurity>> securityContextCustomizer) throws Exception {
        securityContextCustomizer.customize(this.getOrApply(new SecurityContextConfigurer()));
        return this;
    }

    public HttpSecurity servletApi(Customizer<ServletApiConfigurer<HttpSecurity>> servletApiCustomizer) throws Exception {
        servletApiCustomizer.customize(this.getOrApply(new ServletApiConfigurer()));
        return this;
    }

    public HttpSecurity csrf(Customizer<CsrfConfigurer<HttpSecurity>> csrfCustomizer) throws Exception {
        ApplicationContext context = this.getContext();
        csrfCustomizer.customize(this.getOrApply(new CsrfConfigurer(context)));
        return this;
    }

    public HttpSecurity logout(Customizer<LogoutConfigurer<HttpSecurity>> logoutCustomizer) throws Exception {
        logoutCustomizer.customize(this.getOrApply(new LogoutConfigurer()));
        return this;
    }

    public HttpSecurity anonymous(Customizer<AnonymousConfigurer<HttpSecurity>> anonymousCustomizer) throws Exception {
        anonymousCustomizer.customize(this.getOrApply(new AnonymousConfigurer()));
        return this;
    }

    public HttpSecurity formLogin(Customizer<FormLoginConfigurer<HttpSecurity>> formLoginCustomizer) throws Exception {
        formLoginCustomizer.customize(this.getOrApply(new FormLoginConfigurer()));
        return this;
    }

    public HttpSecurity saml2Login(Customizer<Saml2LoginConfigurer<HttpSecurity>> saml2LoginCustomizer) throws Exception {
        saml2LoginCustomizer.customize(this.getOrApply(new Saml2LoginConfigurer()));
        return this;
    }

    public HttpSecurity saml2Logout(Customizer<Saml2LogoutConfigurer<HttpSecurity>> saml2LogoutCustomizer) throws Exception {
        saml2LogoutCustomizer.customize(this.getOrApply(new Saml2LogoutConfigurer(this.getContext())));
        return this;
    }

    public HttpSecurity saml2Metadata(Customizer<Saml2MetadataConfigurer<HttpSecurity>> saml2MetadataConfigurer) throws Exception {
        saml2MetadataConfigurer.customize(this.getOrApply(new Saml2MetadataConfigurer(this.getContext())));
        return this;
    }

    public HttpSecurity oauth2Login(Customizer<OAuth2LoginConfigurer<HttpSecurity>> oauth2LoginCustomizer) throws Exception {
        oauth2LoginCustomizer.customize(this.getOrApply(new OAuth2LoginConfigurer()));
        return this;
    }

    public OidcLogoutConfigurer<HttpSecurity> oidcLogout() throws Exception {
        return this.getOrApply(new OidcLogoutConfigurer());
    }

    public HttpSecurity oidcLogout(Customizer<OidcLogoutConfigurer<HttpSecurity>> oidcLogoutCustomizer) throws Exception {
        oidcLogoutCustomizer.customize(this.getOrApply(new OidcLogoutConfigurer()));
        return this;
    }

    public HttpSecurity oauth2Client(Customizer<OAuth2ClientConfigurer<HttpSecurity>> oauth2ClientCustomizer) throws Exception {
        oauth2ClientCustomizer.customize(this.getOrApply(new OAuth2ClientConfigurer()));
        return this;
    }

    public HttpSecurity oauth2ResourceServer(Customizer<OAuth2ResourceServerConfigurer<HttpSecurity>> oauth2ResourceServerCustomizer) throws Exception {
        OAuth2ResourceServerConfigurer configurer = this.getOrApply(new OAuth2ResourceServerConfigurer(this.getContext()));
        this.postProcess(configurer);
        oauth2ResourceServerCustomizer.customize(configurer);
        return this;
    }

    public HttpSecurity oauth2AuthorizationServer(Customizer<OAuth2AuthorizationServerConfigurer> oauth2AuthorizationServerCustomizer) throws Exception {
        oauth2AuthorizationServerCustomizer.customize(this.getOrApply(new OAuth2AuthorizationServerConfigurer()));
        return this;
    }

    public HttpSecurity oneTimeTokenLogin(Customizer<OneTimeTokenLoginConfigurer<HttpSecurity>> oneTimeTokenLoginConfigurerCustomizer) throws Exception {
        oneTimeTokenLoginConfigurerCustomizer.customize(this.getOrApply(new OneTimeTokenLoginConfigurer(this.getContext())));
        return this;
    }

    @Deprecated
    public HttpSecurity requiresChannel(Customizer<ChannelSecurityConfigurer.ChannelRequestMatcherRegistry> requiresChannelCustomizer) throws Exception {
        ApplicationContext context = this.getContext();
        requiresChannelCustomizer.customize(this.getOrApply(new ChannelSecurityConfigurer(context)).getRegistry());
        return this;
    }

    public HttpSecurity redirectToHttps(Customizer<HttpsRedirectConfigurer<HttpSecurity>> httpsRedirectConfigurerCustomizer) throws Exception {
        httpsRedirectConfigurerCustomizer.customize(this.getOrApply(new HttpsRedirectConfigurer()));
        return this;
    }

    public HttpSecurity httpBasic(Customizer<HttpBasicConfigurer<HttpSecurity>> httpBasicCustomizer) throws Exception {
        httpBasicCustomizer.customize(this.getOrApply(new HttpBasicConfigurer()));
        return this;
    }

    public HttpSecurity passwordManagement(Customizer<PasswordManagementConfigurer<HttpSecurity>> passwordManagementCustomizer) throws Exception {
        passwordManagementCustomizer.customize(this.getOrApply(new PasswordManagementConfigurer()));
        return this;
    }

    public HttpSecurity authenticationManager(AuthenticationManager authenticationManager) {
        Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
        this.authenticationManager = authenticationManager;
        return this;
    }

    @Override
    public <C> void setSharedObject(Class<C> sharedType, C object) {
        super.setSharedObject(sharedType, object);
    }

    @Override
    protected void beforeConfigure() throws Exception {
        if (this.authenticationManager != null) {
            this.setSharedObject(AuthenticationManager.class, this.authenticationManager);
        } else {
            ObjectPostProcessor<AuthenticationManager> postProcessor = this.getAuthenticationManagerPostProcessor();
            AuthenticationManager manager = (AuthenticationManager)this.getAuthenticationRegistry().build();
            if (manager != null) {
                this.setSharedObject(AuthenticationManager.class, postProcessor.postProcess(manager));
            }
        }
    }

    @Override
    protected DefaultSecurityFilterChain performBuild() {
        this.filters.sort((Comparator<OrderedFilter>)OrderComparator.INSTANCE);
        ArrayList<Filter> sortedFilters = new ArrayList<Filter>(this.filters.size());
        for (Filter filter : this.filters) {
            sortedFilters.add(((OrderedFilter)filter).filter);
        }
        return new DefaultSecurityFilterChain(this.requestMatcher, sortedFilters);
    }

    @Override
    public HttpSecurity authenticationProvider(AuthenticationProvider authenticationProvider) {
        this.getAuthenticationRegistry().authenticationProvider(authenticationProvider);
        return this;
    }

    @Override
    public HttpSecurity userDetailsService(UserDetailsService userDetailsService) throws Exception {
        this.getAuthenticationRegistry().userDetailsService(userDetailsService);
        return this;
    }

    private AuthenticationManagerBuilder getAuthenticationRegistry() {
        return this.getSharedObject(AuthenticationManagerBuilder.class);
    }

    @Override
    public HttpSecurity addFilterAfter(Filter filter, Class<? extends Filter> afterFilter) {
        return this.addFilterAtOffsetOf(filter, 1, afterFilter);
    }

    @Override
    public HttpSecurity addFilterBefore(Filter filter, Class<? extends Filter> beforeFilter) {
        return this.addFilterAtOffsetOf(filter, -1, beforeFilter);
    }

    private HttpSecurity addFilterAtOffsetOf(Filter filter, int offset, Class<? extends Filter> registeredFilter) {
        Integer registeredFilterOrder = this.filterOrders.getOrder(registeredFilter);
        if (registeredFilterOrder == null) {
            throw new IllegalArgumentException("The Filter class " + registeredFilter.getName() + " does not have a registered order");
        }
        int order = registeredFilterOrder + offset;
        this.filters.add(new OrderedFilter(filter, order));
        this.filterOrders.put(filter.getClass(), order);
        return this;
    }

    @Override
    public HttpSecurity addFilter(Filter filter) {
        Integer order = this.filterOrders.getOrder(filter.getClass());
        if (order == null) {
            throw new IllegalArgumentException("The Filter class " + filter.getClass().getName() + " does not have a registered order and cannot be added without a specified order. Consider using addFilterBefore or addFilterAfter instead.");
        }
        this.filters.add(new OrderedFilter(filter, order));
        return this;
    }

    public HttpSecurity addFilterAt(Filter filter, Class<? extends Filter> atFilter) {
        return this.addFilterAtOffsetOf(filter, 0, atFilter);
    }

    public HttpSecurity securityMatchers(Customizer<RequestMatcherConfigurer> requestMatcherCustomizer) {
        requestMatcherCustomizer.customize(this.requestMatcherConfigurer);
        return this;
    }

    public HttpSecurity securityMatcher(RequestMatcher requestMatcher) {
        this.requestMatcher = requestMatcher;
        return this;
    }

    public HttpSecurity securityMatcher(String ... patterns) {
        ArrayList<PathPatternRequestMatcher> matchers = new ArrayList<PathPatternRequestMatcher>();
        PathPatternRequestMatcher.Builder builder = this.getSharedObject(PathPatternRequestMatcher.Builder.class);
        for (String pattern : patterns) {
            matchers.add(builder.matcher(pattern));
        }
        this.requestMatcher = new OrRequestMatcher(matchers);
        return this;
    }

    public HttpSecurity webAuthn(Customizer<WebAuthnConfigurer<HttpSecurity>> webAuthn) throws Exception {
        webAuthn.customize(this.getOrApply(new WebAuthnConfigurer()));
        return this;
    }

    private <C extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity>> C getOrApply(C configurer) throws Exception {
        SecurityConfigurerAdapter existingConfig = (SecurityConfigurerAdapter)this.getConfigurer(configurer.getClass());
        if (existingConfig != null) {
            return (C)existingConfig;
        }
        this.with(configurer);
        return configurer;
    }

    private ObjectPostProcessor<AuthenticationManager> getAuthenticationManagerPostProcessor() {
        ApplicationContext context = this.getContext();
        ResolvableType type = ResolvableType.forClassWithGenerics(ObjectPostProcessor.class, (Class[])new Class[]{AuthenticationManager.class});
        ObjectProvider manager = context.getBeanProvider(type);
        return (ObjectPostProcessor)manager.getIfUnique(ObjectPostProcessor::identity);
    }

    public class RequestMatcherConfigurer
    extends AbstractRequestMatcherRegistry<RequestMatcherConfigurer> {
        protected List<RequestMatcher> matchers = new ArrayList<RequestMatcher>();

        RequestMatcherConfigurer(ApplicationContext context) {
            this.setApplicationContext(context);
        }

        @Override
        protected RequestMatcherConfigurer chainRequestMatchers(List<RequestMatcher> requestMatchers) {
            this.setMatchers(requestMatchers);
            return this;
        }

        private void setMatchers(List<? extends RequestMatcher> requestMatchers) {
            this.matchers.addAll(requestMatchers);
            HttpSecurity.this.securityMatcher((RequestMatcher)new OrRequestMatcher(this.matchers));
        }
    }

    private static final class OrderedFilter
    implements Ordered,
    Filter {
        private final Filter filter;
        private final int order;

        private OrderedFilter(Filter filter, int order) {
            this.filter = filter;
            this.order = order;
        }

        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
            this.filter.doFilter(servletRequest, servletResponse, filterChain);
        }

        public int getOrder() {
            return this.order;
        }

        public String toString() {
            return "OrderedFilter{filter=" + String.valueOf(this.filter) + ", order=" + this.order + "}";
        }
    }
}

