/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.saml2;

import jakarta.servlet.Filter;
import java.util.function.Function;
import org.opensaml.core.Version;
import org.springframework.context.ApplicationContext;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.saml2.Saml2LoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.saml2.Saml2LogoutConfigurer;
import org.springframework.security.saml2.provider.service.metadata.OpenSaml5MetadataResolver;
import org.springframework.security.saml2.provider.service.metadata.Saml2MetadataResolver;
import org.springframework.security.saml2.provider.service.metadata.Saml2MetadataResponseResolver;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.web.Saml2MetadataFilter;
import org.springframework.security.saml2.provider.service.web.metadata.RequestMatcherMetadataResponseResolver;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public class Saml2MetadataConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<Saml2LogoutConfigurer<H>, H> {
    private static final boolean USE_OPENSAML_5 = Version.getVersion().startsWith("5");
    private final ApplicationContext context;
    private Function<RelyingPartyRegistrationRepository, Saml2MetadataResponseResolver> metadataResponseResolver;

    public Saml2MetadataConfigurer(ApplicationContext context) {
        this.context = context;
    }

    public Saml2MetadataConfigurer<H> metadataUrl(String metadataUrl) {
        Assert.hasText((String)metadataUrl, (String)"metadataUrl cannot be empty");
        this.metadataResponseResolver = registrations -> {
            if (USE_OPENSAML_5) {
                RequestMatcherMetadataResponseResolver metadata = new RequestMatcherMetadataResponseResolver(registrations, (Saml2MetadataResolver)new OpenSaml5MetadataResolver());
                metadata.setRequestMatcher((RequestMatcher)this.getRequestMatcherBuilder().matcher(metadataUrl));
                return metadata;
            }
            throw new IllegalArgumentException("Spring Security does not support OpenSAML " + Version.getVersion() + ". Please use OpenSAML 5");
        };
        return this;
    }

    public Saml2MetadataConfigurer<H> metadataResponseResolver(Saml2MetadataResponseResolver metadataResponseResolver) {
        Assert.notNull((Object)metadataResponseResolver, (String)"metadataResponseResolver cannot be null");
        this.metadataResponseResolver = registrations -> metadataResponseResolver;
        return this;
    }

    public H and() {
        return (H)((HttpSecurityBuilder)this.getBuilder());
    }

    @Override
    public void configure(H http) throws Exception {
        Saml2MetadataResponseResolver metadataResponseResolver = this.createMetadataResponseResolver(http);
        http.addFilterBefore((Filter)new Saml2MetadataFilter(metadataResponseResolver), BasicAuthenticationFilter.class);
    }

    private Saml2MetadataResponseResolver createMetadataResponseResolver(H http) {
        if (this.metadataResponseResolver != null) {
            RelyingPartyRegistrationRepository registrations = this.getRelyingPartyRegistrationRepository(http);
            return this.metadataResponseResolver.apply(registrations);
        }
        Saml2MetadataResponseResolver metadataResponseResolver = this.getBeanOrNull(Saml2MetadataResponseResolver.class);
        if (metadataResponseResolver != null) {
            return metadataResponseResolver;
        }
        RelyingPartyRegistrationRepository registrations = this.getRelyingPartyRegistrationRepository(http);
        if (USE_OPENSAML_5) {
            return new RequestMatcherMetadataResponseResolver(registrations, (Saml2MetadataResolver)new OpenSaml5MetadataResolver());
        }
        throw new IllegalArgumentException("Spring Security does not support OpenSAML " + Version.getVersion() + ". Please use OpenSAML 5");
    }

    private RelyingPartyRegistrationRepository getRelyingPartyRegistrationRepository(H http) {
        Saml2LoginConfigurer login = http.getConfigurer(Saml2LoginConfigurer.class);
        if (login != null) {
            return login.relyingPartyRegistrationRepository(http);
        }
        return this.getBeanOrNull(RelyingPartyRegistrationRepository.class);
    }

    private <C> C getBeanOrNull(Class<C> clazz) {
        if (this.context == null) {
            return null;
        }
        return (C)this.context.getBeanProvider(clazz).getIfAvailable();
    }
}

