/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.AbstractOAuth2Configurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2AuthorizationServerConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2DeviceAuthorizationEndpointConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2PushedAuthorizationRequestEndpointConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OidcClientRegistrationEndpointConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OidcLogoutEndpointConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OidcProviderConfigurationEndpointConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OidcUserInfoEndpointConfigurer;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.server.authorization.context.AuthorizationServerContext;
import org.springframework.security.oauth2.server.authorization.context.AuthorizationServerContextHolder;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.util.UriComponentsBuilder;

public final class OidcConfigurer
extends AbstractOAuth2Configurer {
    private final Map<Class<? extends AbstractOAuth2Configurer>, AbstractOAuth2Configurer> configurers = new LinkedHashMap<Class<? extends AbstractOAuth2Configurer>, AbstractOAuth2Configurer>();
    private RequestMatcher requestMatcher;

    OidcConfigurer(ObjectPostProcessor<Object> objectPostProcessor) {
        super(objectPostProcessor);
        this.addConfigurer(OidcProviderConfigurationEndpointConfigurer.class, new OidcProviderConfigurationEndpointConfigurer(objectPostProcessor));
        this.addConfigurer(OidcLogoutEndpointConfigurer.class, new OidcLogoutEndpointConfigurer(objectPostProcessor));
        this.addConfigurer(OidcUserInfoEndpointConfigurer.class, new OidcUserInfoEndpointConfigurer(objectPostProcessor));
    }

    public OidcConfigurer providerConfigurationEndpoint(Customizer<OidcProviderConfigurationEndpointConfigurer> providerConfigurationEndpointCustomizer) {
        providerConfigurationEndpointCustomizer.customize(this.getConfigurer(OidcProviderConfigurationEndpointConfigurer.class));
        return this;
    }

    public OidcConfigurer logoutEndpoint(Customizer<OidcLogoutEndpointConfigurer> logoutEndpointCustomizer) {
        logoutEndpointCustomizer.customize(this.getConfigurer(OidcLogoutEndpointConfigurer.class));
        return this;
    }

    public OidcConfigurer clientRegistrationEndpoint(Customizer<OidcClientRegistrationEndpointConfigurer> clientRegistrationEndpointCustomizer) {
        OidcClientRegistrationEndpointConfigurer clientRegistrationEndpointConfigurer = this.getConfigurer(OidcClientRegistrationEndpointConfigurer.class);
        if (clientRegistrationEndpointConfigurer == null) {
            this.addConfigurer(OidcClientRegistrationEndpointConfigurer.class, new OidcClientRegistrationEndpointConfigurer(this.getObjectPostProcessor()));
            clientRegistrationEndpointConfigurer = this.getConfigurer(OidcClientRegistrationEndpointConfigurer.class);
        }
        clientRegistrationEndpointCustomizer.customize(clientRegistrationEndpointConfigurer);
        return this;
    }

    public OidcConfigurer userInfoEndpoint(Customizer<OidcUserInfoEndpointConfigurer> userInfoEndpointCustomizer) {
        userInfoEndpointCustomizer.customize(this.getConfigurer(OidcUserInfoEndpointConfigurer.class));
        return this;
    }

    @Override
    void init(HttpSecurity httpSecurity) {
        ArrayList requestMatchers = new ArrayList();
        this.configurers.values().forEach(configurer -> {
            configurer.init(httpSecurity);
            requestMatchers.add(configurer.getRequestMatcher());
        });
        this.requestMatcher = new OrRequestMatcher(requestMatchers);
    }

    @Override
    void configure(HttpSecurity httpSecurity) {
        OAuth2PushedAuthorizationRequestEndpointConfigurer pushedAuthorizationRequestEndpointConfigurer;
        OAuth2DeviceAuthorizationEndpointConfigurer deviceAuthorizationEndpointConfigurer;
        OidcClientRegistrationEndpointConfigurer clientRegistrationEndpointConfigurer = this.getConfigurer(OidcClientRegistrationEndpointConfigurer.class);
        if (clientRegistrationEndpointConfigurer != null) {
            OidcProviderConfigurationEndpointConfigurer providerConfigurationEndpointConfigurer = this.getConfigurer(OidcProviderConfigurationEndpointConfigurer.class);
            providerConfigurationEndpointConfigurer.addDefaultProviderConfigurationCustomizer(builder -> {
                AuthorizationServerContext authorizationServerContext = AuthorizationServerContextHolder.getContext();
                String issuer = authorizationServerContext.getIssuer();
                AuthorizationServerSettings authorizationServerSettings = authorizationServerContext.getAuthorizationServerSettings();
                String clientRegistrationEndpoint = UriComponentsBuilder.fromUriString((String)issuer).path(authorizationServerSettings.getOidcClientRegistrationEndpoint()).build().toUriString();
                builder.clientRegistrationEndpoint(clientRegistrationEndpoint);
            });
        }
        if ((deviceAuthorizationEndpointConfigurer = httpSecurity.getConfigurer(OAuth2AuthorizationServerConfigurer.class).getConfigurer(OAuth2DeviceAuthorizationEndpointConfigurer.class)) != null) {
            OidcProviderConfigurationEndpointConfigurer providerConfigurationEndpointConfigurer = this.getConfigurer(OidcProviderConfigurationEndpointConfigurer.class);
            providerConfigurationEndpointConfigurer.addDefaultProviderConfigurationCustomizer(builder -> {
                AuthorizationServerContext authorizationServerContext = AuthorizationServerContextHolder.getContext();
                String issuer = authorizationServerContext.getIssuer();
                AuthorizationServerSettings authorizationServerSettings = authorizationServerContext.getAuthorizationServerSettings();
                String deviceAuthorizationEndpoint = UriComponentsBuilder.fromUriString((String)issuer).path(authorizationServerSettings.getDeviceAuthorizationEndpoint()).build().toUriString();
                builder.deviceAuthorizationEndpoint(deviceAuthorizationEndpoint);
                builder.grantType(AuthorizationGrantType.DEVICE_CODE.getValue());
            });
        }
        if ((pushedAuthorizationRequestEndpointConfigurer = httpSecurity.getConfigurer(OAuth2AuthorizationServerConfigurer.class).getConfigurer(OAuth2PushedAuthorizationRequestEndpointConfigurer.class)) != null) {
            OidcProviderConfigurationEndpointConfigurer providerConfigurationEndpointConfigurer = this.getConfigurer(OidcProviderConfigurationEndpointConfigurer.class);
            providerConfigurationEndpointConfigurer.addDefaultProviderConfigurationCustomizer(builder -> {
                AuthorizationServerContext authorizationServerContext = AuthorizationServerContextHolder.getContext();
                String issuer = authorizationServerContext.getIssuer();
                AuthorizationServerSettings authorizationServerSettings = authorizationServerContext.getAuthorizationServerSettings();
                String pushedAuthorizationRequestEndpoint = UriComponentsBuilder.fromUriString((String)issuer).path(authorizationServerSettings.getPushedAuthorizationRequestEndpoint()).build().toUriString();
                builder.pushedAuthorizationRequestEndpoint(pushedAuthorizationRequestEndpoint);
            });
        }
        this.configurers.values().forEach(configurer -> configurer.configure(httpSecurity));
    }

    @Override
    RequestMatcher getRequestMatcher() {
        return this.requestMatcher;
    }

    <T> T getConfigurer(Class<T> type) {
        return (T)this.configurers.get(type);
    }

    private <T extends AbstractOAuth2Configurer> void addConfigurer(Class<T> configurerType, T configurer) {
        this.configurers.put(configurerType, configurer);
    }
}

