/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.crypto.password4j;

import com.password4j.AlgorithmFinder;
import com.password4j.Hash;
import com.password4j.HashingFunction;
import com.password4j.PBKDF2Function;
import com.password4j.Password;
import java.security.SecureRandom;
import java.util.Base64;
import org.springframework.security.crypto.password.AbstractValidatingPasswordEncoder;
import org.springframework.util.Assert;

public class Pbkdf2Password4jPasswordEncoder
extends AbstractValidatingPasswordEncoder {
    private static final String DELIMITER = ":";
    private static final int DEFAULT_SALT_LENGTH = 32;
    private final PBKDF2Function pbkdf2Function;
    private final SecureRandom secureRandom;
    private final int saltLength;

    public Pbkdf2Password4jPasswordEncoder() {
        this(AlgorithmFinder.getPBKDF2Instance());
    }

    public Pbkdf2Password4jPasswordEncoder(PBKDF2Function pbkdf2Function) {
        this(pbkdf2Function, 32);
    }

    public Pbkdf2Password4jPasswordEncoder(PBKDF2Function pbkdf2Function, int saltLength) {
        Assert.notNull((Object)pbkdf2Function, (String)"pbkdf2Function cannot be null");
        Assert.isTrue((saltLength > 0 ? 1 : 0) != 0, (String)"saltLength must be positive");
        this.pbkdf2Function = pbkdf2Function;
        this.saltLength = saltLength;
        this.secureRandom = new SecureRandom();
    }

    @Override
    protected String encodeNonNullPassword(String rawPassword) {
        byte[] salt = new byte[this.saltLength];
        this.secureRandom.nextBytes(salt);
        Hash hash = Password.hash((CharSequence)rawPassword).addSalt(salt).with((HashingFunction)this.pbkdf2Function);
        String encodedSalt = Base64.getEncoder().encodeToString(salt);
        String encodedHash = hash.getResult();
        return encodedSalt + DELIMITER + encodedHash;
    }

    @Override
    protected boolean matchesNonNull(String rawPassword, String encodedPassword) {
        if (!encodedPassword.contains(DELIMITER)) {
            return false;
        }
        String[] parts = encodedPassword.split(DELIMITER, 2);
        if (parts.length != 2) {
            return false;
        }
        try {
            byte[] salt = Base64.getDecoder().decode(parts[0]);
            String expectedHash = parts[1];
            Hash hash = Password.hash((CharSequence)rawPassword).addSalt(salt).with((HashingFunction)this.pbkdf2Function);
            return expectedHash.equals(hash.getResult());
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    @Override
    protected boolean upgradeEncodingNonNull(String encodedPassword) {
        return false;
    }
}

