/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.soap.addressing;

import java.util.Map;
import javax.inject.Named;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.quickstarts.soap.addressing.Order;
import org.switchyard.quickstarts.soap.addressing.UnknownItem;
import org.w3c.dom.Element;

@Named(value="orderProcessor")
public class OrderProcessor
implements Processor {
    public void process(Exchange exchange) throws Exception {
        Order order = (Order)exchange.getIn().getBody(Order.class);
        System.out.println("Received Order " + order.getItem() + " with quantity " + order.getQuantity() + ".");
        Map headers = exchange.getIn().getHeaders();
        if (order.getItem().equals("Airbus")) {
            throw new UnknownItem("Sorry, Airbus is no longer available with us!");
        }
        SOAPHeaderElement messageId = (SOAPHeaderElement)exchange.getIn().getHeaders().get("{http://www.w3.org/2005/08/addressing}MessageID");
        if (messageId == null) {
            messageId = (SOAPHeaderElement)exchange.getIn().getHeaders().get("{http://www.w3.org/2005/08/addressing}messageid");
        }
        String replyToStr = "<wsa:ReplyTo xmlns:wsa=\"http://www.w3.org/2005/08/addressing\"><wsa:Address>http://localhost:8080/soap-addressing/client/ResponseService</wsa:Address></wsa:ReplyTo>";
        Element replyTo = XMLHelper.getDocumentFromString((String)replyToStr).getDocumentElement();
        String faultToStr = "<wsa:FaultTo xmlns:wsa=\"http://www.w3.org/2005/08/addressing\"><wsa:Address>http://localhost:8080/soap-addressing/fault/FaultService</wsa:Address></wsa:FaultTo>";
        Element faultTo = XMLHelper.getDocumentFromString((String)faultToStr).getDocumentElement();
        String relatesToStr = "<wsa:RelatesTo xmlns:wsa=\"http://www.w3.org/2005/08/addressing\">" + messageId.getValue() + "</wsa:RelatesTo>";
        Element relatesTo = XMLHelper.getDocumentFromString((String)relatesToStr).getDocumentElement();
        exchange.getOut().getHeaders().put("{http://www.w3.org/2005/08/addressing}replyto", replyTo);
        exchange.getOut().getHeaders().put("{http://www.w3.org/2005/08/addressing}relatesto", relatesTo);
        exchange.getOut().getHeaders().put("{http://www.w3.org/2005/08/addressing}faultto", faultTo);
        exchange.getOut().setBody((Object)order);
    }
}

