/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.nio.channels.ClosedChannelException;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.netty.NettyConsumer;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.util.CamelLogger;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyConsumerExceptionHandler
implements ExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(NettyConsumer.class);
    private final CamelLogger logger;
    private final LoggingLevel closedLoggingLevel;

    public NettyConsumerExceptionHandler(NettyConsumer consumer) {
        this.logger = new CamelLogger(LOG, consumer.getConfiguration().getServerExceptionCaughtLogLevel());
        this.closedLoggingLevel = consumer.getConfiguration().getServerClosedChannelExceptionCaughtLogLevel();
    }

    public void handleException(Throwable exception) {
        this.handleException(null, null, exception);
    }

    public void handleException(String message, Throwable exception) {
        this.handleException(message, null, exception);
    }

    public void handleException(String message, Exchange exchange, Throwable exception) {
        try {
            boolean closed;
            String msg = CamelExchangeException.createExceptionMessage((String)message, (Exchange)exchange, (Throwable)exception);
            boolean bl = closed = ObjectHelper.getException(ClosedChannelException.class, (Throwable)exception) != null;
            if (closed) {
                this.logger.log(msg, exception, this.closedLoggingLevel);
            } else {
                this.logger.log(msg, exception);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

