/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import com.sap.conn.jco.server.JCoServerContext;
import com.sap.conn.jco.server.JCoServerFunctionHandler;
import com.sap.conn.jco.server.JCoServerFunctionHandlerFactory;
import java.util.HashMap;
import java.util.Map;
import org.fusesource.camel.component.sap.SapConsumer;
import org.fusesource.camel.component.sap.SapServerSessionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionHandlerFactory
implements JCoServerFunctionHandlerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(FunctionHandlerFactory.class);
    private Map<String, JCoServerFunctionHandler> callHandlers = new HashMap<String, JCoServerFunctionHandler>();
    private Map<String, SapServerSessionContext> statefulSessionContexts = new HashMap<String, SapServerSessionContext>();

    public void registerHandler(String functionName, JCoServerFunctionHandler handler) {
        this.callHandlers.put(functionName, handler);
    }

    public JCoServerFunctionHandler unregisterHandler(String functionName) {
        return this.callHandlers.remove(functionName);
    }

    public void sessionClosed(JCoServerContext serverContext, String message, boolean error) {
        this.statefulSessionContexts.remove(serverContext.getSessionID());
        LOG.debug("Session " + serverContext.getSessionID() + " was closed " + (error ? message : "by SAP system"));
    }

    public JCoServerFunctionHandler getCallHandler(JCoServerContext serverContext, String functionName) {
        SapConsumer consumer;
        JCoServerFunctionHandler handler = this.callHandlers.get(functionName);
        if (handler instanceof SapConsumer && (consumer = (SapConsumer)handler).isStateful()) {
            SapServerSessionContext sessionContext;
            if (!serverContext.isStatefulSession()) {
                serverContext.setStateful(true);
                sessionContext = new SapServerSessionContext();
                this.statefulSessionContexts.put(serverContext.getSessionID(), sessionContext);
            } else {
                sessionContext = this.statefulSessionContexts.get(serverContext.getSessionID());
                if (sessionContext == null) {
                    throw new RuntimeException("Failed to find session context for session '" + serverContext.getSessionID() + "'");
                }
            }
            consumer.setSessionContext(sessionContext);
        }
        return handler;
    }
}

