/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import com.sap.conn.idoc.IDocDocumentList;
import com.sap.conn.idoc.jco.JCoIDocHandler;
import com.sap.conn.idoc.jco.JCoIDocHandlerFactory;
import com.sap.conn.idoc.jco.JCoIDocServerContext;
import com.sap.conn.jco.server.JCoServerContext;
import java.util.HashMap;
import java.util.Map;

public class IDocHandlerFactory
implements JCoIDocHandlerFactory {
    private Map<String, JCoIDocHandler> iDocHandlers = new HashMap<String, JCoIDocHandler>();
    JCoIDocHandler iDocHandler = new JCoIDocHandler(){

        public void handleRequest(JCoServerContext serverContext, IDocDocumentList iDocDocumentList) {
            String key = IDocHandlerFactory.this.createKey(iDocDocumentList.getIDocType(), iDocDocumentList.getIDocTypeExtension(), iDocDocumentList.getSystemRelease(), iDocDocumentList.getApplicationRelease());
            JCoIDocHandler iDocHandler = (JCoIDocHandler)IDocHandlerFactory.this.iDocHandlers.get(key);
            if (iDocHandler != null) {
                iDocHandler.handleRequest(serverContext, iDocDocumentList);
            }
        }
    };

    public void registerHandler(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease, JCoIDocHandler iDocHandler) {
        this.iDocHandlers.put(this.createKey(iDocType, iDocTypeExtension, systemRelease, applicationRelease), iDocHandler);
    }

    public JCoIDocHandler unregisterHandler(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) {
        return this.iDocHandlers.remove(this.createKey(iDocType, iDocTypeExtension, systemRelease, applicationRelease));
    }

    public JCoIDocHandler getIDocHandler(JCoIDocServerContext serverContext) {
        return this.iDocHandler;
    }

    protected String createKey(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) {
        StringBuilder key = new StringBuilder(100);
        key.append(iDocType);
        key.append("|");
        if (iDocTypeExtension != null) {
            key.append(iDocTypeExtension);
        }
        key.append("|");
        if (systemRelease != null) {
            key.append(systemRelease.replace(".", ""));
        }
        key.append("|");
        if (applicationRelease != null) {
            key.append(applicationRelease.replace(".", ""));
        }
        return key.toString();
    }
}

