/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultProducer;
import org.fusesource.camel.component.sap.DestinationRfcTransactionHandler;
import org.fusesource.camel.component.sap.SapQueuedIDocDestinationEndpoint;
import org.fusesource.camel.component.sap.model.idoc.Document;
import org.fusesource.camel.component.sap.util.IDocUtil;
import org.fusesource.camel.component.sap.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapQueuedIDocProducer
extends DefaultProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(SapQueuedIDocProducer.class);

    public SapQueuedIDocProducer(SapQueuedIDocDestinationEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        Document document = (Document)exchange.getIn().getBody(Document.class);
        if (document == null) {
            LOG.warn("Exchange input message body does not contain IDoc document");
            return;
        }
        if (LOG.isDebugEnabled()) {
            try {
                LOG.debug("Sending IDoc document to ''{}''", (Object)this.getEndpoint().getEndpointUri());
                LOG.debug("Document: " + (document == null ? document : Util.marshal(document)));
            }
            catch (Exception e) {
                LOG.warn("Failed to log request", (Throwable)e);
            }
        }
        String tid = DestinationRfcTransactionHandler.getTID(exchange, this.getEndpoint().getDestination());
        IDocUtil.sendDocument(this.getEndpoint().getDestination(), document, tid, this.getEndpoint().getQueueName());
    }

    public SapQueuedIDocDestinationEndpoint getEndpoint() {
        return (SapQueuedIDocDestinationEndpoint)super.getEndpoint();
    }
}

