/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.bus.camel.processors;

import java.util.List;
import java.util.Map;
import org.apache.camel.Processor;
import org.jboss.logging.Logger;
import org.switchyard.Exchange;
import org.switchyard.ExchangeInterceptor;
import org.switchyard.ExchangeState;
import org.switchyard.HandlerException;
import org.switchyard.ServiceDomain;
import org.switchyard.bus.camel.BusLogger;
import org.switchyard.bus.camel.CamelExchange;
import org.switchyard.handlers.MessageTraceHandler;

public class InterceptProcessor
implements Processor {
    private static final String INTERCEPT_PREFIX = "org.switchyard.bus.camel.intercept.";
    private static final String BEFORE = "before";
    private static final String AFTER = "after";
    private String _target;
    private String _property;
    private ServiceDomain _domain;
    private MessageTraceHandler _trace;
    private static Logger _log = Logger.getLogger(InterceptProcessor.class);

    public InterceptProcessor(String target, ServiceDomain domain) {
        this._domain = domain;
        this._target = target;
        this._property = INTERCEPT_PREFIX + this._target;
        this._trace = new MessageTraceHandler();
    }

    public void process(org.apache.camel.Exchange ex) throws Exception {
        this.traceMessage(ex);
        this.fireInterceptors(ex);
    }

    public String toString() {
        return "InterceptProcessor@" + System.identityHashCode(this);
    }

    private void traceMessage(org.apache.camel.Exchange exchange) {
        if (!this.traceEnabled(exchange)) {
            return;
        }
        try {
            CamelExchange syEx = new CamelExchange(exchange);
            if (ExchangeState.FAULT.equals((Object)syEx.getState())) {
                this._trace.handleFault((Exchange)syEx);
            } else {
                this._trace.handleMessage((Exchange)syEx);
            }
        }
        catch (Exception ex) {
            _log.warn((Object)"Failed while generating message trace.", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void fireInterceptors(org.apache.camel.Exchange ex) throws HandlerException {
        Map interceptors = ex.getContext().getRegistry().lookupByType(ExchangeInterceptor.class);
        if (interceptors == null || interceptors.size() <= 0) return;
        CamelExchange syEx = new CamelExchange(ex);
        try {
            boolean callBefore = this.isBefore(ex);
            boolean callAfter = this.isAfter(ex);
            for (ExchangeInterceptor interceptor : interceptors.values()) {
                if (!this.matchesTarget(interceptor)) continue;
                if (callBefore) {
                    interceptor.before(this._target, (Exchange)syEx);
                    continue;
                }
                if (!callAfter) continue;
                try {
                    interceptor.after(this._target, (Exchange)syEx);
                }
                catch (Exception error) {
                    if (ExchangeState.FAULT.equals((Object)syEx.getState())) {
                        BusLogger.ROOT_LOGGER.alreadyInFaultState(error);
                        continue;
                    }
                    if (!(error instanceof HandlerException)) throw new HandlerException((Throwable)error);
                    throw (HandlerException)error;
                    return;
                }
            }
        }
        finally {
            if (this.isBefore(ex)) {
                this.setBefore(ex);
            } else {
                this.setAfter(ex);
            }
        }
    }

    boolean traceEnabled(org.apache.camel.Exchange ex) {
        Object traceProp = this._domain.getProperty("org.switchyard.handlers.messageTrace.enabled");
        if (traceProp != null) {
            boolean enabled = false;
            enabled = Boolean.class.isAssignableFrom(traceProp.getClass()) ? (Boolean)traceProp : (String.class.isAssignableFrom(traceProp.getClass()) ? Boolean.valueOf((String)traceProp).booleanValue() : Boolean.valueOf(traceProp.toString()).booleanValue());
            return enabled;
        }
        return (Boolean)ex.getProperty("org.switchyard.handlers.messageTrace.enabled", (Object)false, Boolean.class);
    }

    private void setBefore(org.apache.camel.Exchange ex) {
        ex.setProperty(this._property, (Object)BEFORE);
    }

    private void setAfter(org.apache.camel.Exchange ex) {
        ex.setProperty(this._property, (Object)AFTER);
    }

    private boolean isBefore(org.apache.camel.Exchange ex) {
        return ex.getProperty(this._property) == null;
    }

    private boolean isAfter(org.apache.camel.Exchange ex) {
        return BEFORE.equals(ex.getProperty(this._property));
    }

    private boolean matchesTarget(ExchangeInterceptor interceptor) {
        List targets = interceptor.getTargets();
        return targets != null && targets.contains(this._target);
    }
}

