/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxrs;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.cxf.jaxrs.DefaultCxfRsBinding;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.InputStreamDataSource;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.apache.cxf.message.MessageContentsList;

public class SimpleCxfRsBinding
extends DefaultCxfRsBinding {
    private static final Set<Class<?>> HEADER_ANNOTATIONS = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(CookieParam.class, FormParam.class, PathParam.class, HeaderParam.class, MatrixParam.class, QueryParam.class)));
    private static final Set<Class<?>> BINARY_ATTACHMENT_TYPES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Attachment.class, DataHandler.class, DataSource.class, InputStream.class)));
    private static final Class<?>[] NO_PARAMETER_TYPES = null;
    private static final Object[] NO_PARAMETERS = null;
    private Map<Method, MethodSpec> methodSpecCache = new ConcurrentHashMap<Method, MethodSpec>();

    @Override
    public void populateExchangeFromCxfRsRequest(org.apache.cxf.message.Exchange cxfExchange, Exchange camelExchange, Method method, Object[] paramArray) {
        super.populateExchangeFromCxfRsRequest(cxfExchange, camelExchange, method, paramArray);
        Message in = camelExchange.getIn();
        this.bindHeadersFromSubresourceLocators(cxfExchange, camelExchange);
        MethodSpec spec = this.methodSpecCache.get(method);
        if (spec == null) {
            spec = MethodSpec.fromMethod(method);
            this.methodSpecCache.put(method, spec);
        }
        this.bindParameters(in, paramArray, spec.paramNames, spec.numberParameters);
        this.bindBody(in, paramArray, spec.entityIndex);
        if (spec.multipart) {
            this.transferMultipartParameters(paramArray, spec.multipartNames, spec.multipartTypes, in);
        }
    }

    @Override
    public Object populateCxfRsResponseFromExchange(Exchange camelExchange, org.apache.cxf.message.Exchange cxfExchange) throws Exception {
        Object base = super.populateCxfRsResponseFromExchange(camelExchange, cxfExchange);
        return this.buildResponse(camelExchange, base);
    }

    protected Object buildResponse(Exchange camelExchange, Object base) {
        Response.ResponseBuilder response;
        Message m;
        Message message = m = camelExchange.hasOut() ? camelExchange.getOut() : camelExchange.getIn();
        if (base instanceof Response) {
            response = Response.fromResponse((Response)((Response)base));
        } else {
            int status = (Integer)m.getHeader("CamelHttpResponseCode", (Object)Response.Status.OK.getStatusCode(), Integer.class);
            response = Response.status((int)status);
            if (base != null && !(base instanceof MessageContentsList)) {
                response.entity(base);
            }
        }
        Map<String, String> headersToPropagate = this.filterCamelHeadersForResponseHeaders(m.getHeaders(), camelExchange);
        for (Map.Entry<String, String> entry : headersToPropagate.entrySet()) {
            response.header(entry.getKey(), (Object)entry.getValue());
        }
        return response.build();
    }

    protected Map<String, String> filterCamelHeadersForResponseHeaders(Map<String, Object> headers, Exchange camelExchange) {
        HashMap<String, String> answer = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            if (this.getHeaderFilterStrategy().applyFilterToCamelHeaders(entry.getKey(), entry.getValue(), camelExchange)) continue;
            answer.put(entry.getKey(), entry.getValue().toString());
        }
        return answer;
    }

    protected void bindHeadersFromSubresourceLocators(org.apache.cxf.message.Exchange cxfExchange, Exchange camelExchange) {
        MultivaluedMap pathParams = (MultivaluedMap)cxfExchange.getInMessage().get((Object)"jaxrs.template.parameters");
        if (pathParams == null || pathParams.size() == 1 && pathParams.containsKey((Object)"FINAL_MATCH_GROUP")) {
            return;
        }
        Message m = camelExchange.getIn();
        for (Map.Entry entry : pathParams.entrySet()) {
            if ("FINAL_MATCH_GROUP".equals(entry.getKey())) continue;
            m.setHeader((String)entry.getKey(), ((List)entry.getValue()).get(0));
        }
    }

    protected void bindParameters(Message in, Object[] paramArray, String[] paramNames, int numberParameters) {
        if (numberParameters == 0) {
            return;
        }
        for (int i = 0; i < paramNames.length; ++i) {
            if (paramNames[i] == null) continue;
            in.setHeader(paramNames[i], paramArray[i]);
        }
    }

    protected void bindBody(Message in, Object[] paramArray, int singleBodyIndex) {
        if (singleBodyIndex == -1) {
            return;
        }
        in.setBody(paramArray[singleBodyIndex]);
    }

    private void transferMultipartParameters(Object[] paramArray, String[] multipartNames, String[] multipartTypes, Message in) {
        for (int i = 0; i < multipartNames.length; ++i) {
            if (multipartNames[i] == null || paramArray[i] == null) continue;
            if (BINARY_ATTACHMENT_TYPES.contains(paramArray[i].getClass())) {
                this.transferBinaryMultipartParameter(paramArray[i], multipartNames[i], multipartTypes[i], in);
                continue;
            }
            in.setHeader(multipartNames[i], paramArray[i]);
        }
    }

    private void transferBinaryMultipartParameter(Object toMap, String parameterName, String multipartType, Message in) {
        DataHandler dh = null;
        if (toMap instanceof Attachment) {
            dh = ((Attachment)toMap).getDataHandler();
        } else if (toMap instanceof DataSource) {
            dh = new DataHandler((DataSource)toMap);
        } else if (toMap instanceof DataHandler) {
            dh = (DataHandler)toMap;
        } else if (toMap instanceof InputStream) {
            dh = new DataHandler((DataSource)new InputStreamDataSource((InputStream)toMap, multipartType == null ? "application/octet-stream" : multipartType));
        }
        if (dh != null) {
            in.addAttachment(parameterName, dh);
        }
    }

    protected static class MethodSpec {
        private boolean multipart;
        private int numberParameters;
        private int entityIndex = -1;
        private String[] paramNames;
        private String[] multipartNames;
        private String[] multipartTypes;

        protected MethodSpec() {
        }

        public static MethodSpec fromMethod(Method method) {
            int i;
            MethodSpec answer = new MethodSpec();
            Annotation[][] annotations = method.getParameterAnnotations();
            int paramCount = method.getParameterTypes().length;
            answer.paramNames = new String[paramCount];
            answer.multipartNames = new String[paramCount];
            answer.multipartTypes = new String[paramCount];
            for (i = 0; i < paramCount; ++i) {
                for (Annotation a : annotations[i]) {
                    if (HEADER_ANNOTATIONS.contains(a.annotationType())) {
                        try {
                            answer.paramNames[i] = (String)a.annotationType().getMethod("value", NO_PARAMETER_TYPES).invoke((Object)a, NO_PARAMETERS);
                            ++answer.numberParameters;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!Multipart.class.equals(a.annotationType())) continue;
                    Multipart multipart = (Multipart)a;
                    answer.multipart = true;
                    answer.multipartNames[i] = multipart.value();
                    answer.multipartTypes[i] = multipart.type();
                }
            }
            if (!answer.multipart && answer.numberParameters < method.getParameterTypes().length) {
                for (i = 0; i < answer.paramNames.length; ++i) {
                    if (answer.paramNames[i] != null) continue;
                    answer.entityIndex = i;
                    break;
                }
            }
            return answer;
        }
    }
}

