/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.common.handler;

import javax.xml.namespace.QName;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.switchyard.common.lang.Strings;
import org.switchyard.component.camel.common.composer.CamelBindingData;
import org.switchyard.component.camel.common.model.CamelBindingModel;
import org.switchyard.component.common.selector.OperationSelectorFactory;
import org.switchyard.selector.OperationSelector;

public class OperationSelectorProcessor
implements Processor {
    private final QName _serviceName;
    private final CamelBindingModel _bindingModel;
    private final OperationSelector<CamelBindingData> _selector;

    public OperationSelectorProcessor(QName serviceName, CamelBindingModel bindingModel) {
        this._serviceName = serviceName;
        this._bindingModel = bindingModel;
        OperationSelectorFactory selectorFactory = OperationSelectorFactory.getOperationSelectorFactory(CamelBindingData.class);
        this._selector = selectorFactory.newOperationSelector(this._bindingModel.getOperationSelector());
        if (this._selector != null) {
            this._selector.setDefaultNamespace(Strings.trimToNull((String)this._serviceName.getNamespaceURI()));
        }
    }

    public void process(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        in.setHeader("org.switchyard.operationSelector", this._selector);
        exchange.setOut(in.copy());
    }
}

