/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension;

import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.switchyard.as7.extension.services.SwitchYardInjectorService;
import org.switchyard.as7.extension.services.SwitchYardSecurityConfigService;
import org.switchyard.as7.extension.services.SwitchYardSystemSecurityService;
import org.switchyard.security.system.SystemSecurity;

public final class SwitchYardSecurityConfigAdd
extends AbstractAddStepHandler {
    static final SwitchYardSecurityConfigAdd INSTANCE = new SwitchYardSecurityConfigAdd();

    private SwitchYardSecurityConfigAdd() {
    }

    protected void populateModel(ModelNode operation, Resource resource) {
        ModelNode model = resource.getModel();
        this.populateModel(operation, model);
    }

    protected void populateModel(ModelNode operation, ModelNode subModel) {
        if (operation.hasDefined("properties")) {
            subModel.get("properties").set(operation.get("properties"));
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String moduleId = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
        ServiceName serviceName = SwitchYardSecurityConfigService.SERVICE_NAME.append(new String[]{moduleId});
        SwitchYardSecurityConfigService securityConfigService = new SwitchYardSecurityConfigService(moduleId, model);
        ServiceBuilder securityConfigServiceBuilder = context.getServiceTarget().addService(serviceName, (Service)securityConfigService);
        securityConfigServiceBuilder.addDependency(SwitchYardSystemSecurityService.SERVICE_NAME, SystemSecurity.class, securityConfigService.getSystemSecurity());
        securityConfigServiceBuilder.addDependency(SwitchYardInjectorService.SERVICE_NAME, Map.class, securityConfigService.getInjectedValues());
        securityConfigServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        newControllers.add(securityConfigServiceBuilder.install());
    }
}

