/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.serial.jackson.spi;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.switchyard.common.type.reflect.Construction;
import org.switchyard.serial.FormatType;
import org.switchyard.serial.Serializer;
import org.switchyard.serial.jackson.format.JSONJacksonSerializer;
import org.switchyard.serial.spi.SerializationProvider;

public class JacksonSerializationProvider
extends SerializationProvider {
    private static final Map<FormatType, Class<? extends Serializer>> MAP;

    public Set<FormatType> getSupportedFormats() {
        return MAP.keySet();
    }

    public Serializer newSerializer(FormatType format) {
        Class<? extends Serializer> c = MAP.get(format);
        return c != null ? (Serializer)Construction.construct(c) : null;
    }

    static {
        LinkedHashMap<FormatType, Class<JSONJacksonSerializer>> map = new LinkedHashMap<FormatType, Class<JSONJacksonSerializer>>();
        map.put(FormatType.JSON, JSONJacksonSerializer.class);
        MAP = Collections.unmodifiableMap(map);
    }
}

