/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.runtime.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.switchyard.Exchange;
import org.switchyard.Message;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.common.lang.Strings;

public final class ExchangeFormatter {
    private static final String INDENT = System.getProperty("line.separator");

    public static String format(Exchange exchange, boolean printBody) {
        StringBuilder summary = new StringBuilder().append(ExchangeFormatter.indent(0) + "------- Begin Message Trace -------");
        summary.append(ExchangeFormatter.formatHeaders(exchange));
        if (printBody) {
            summary.append(ExchangeFormatter.formatBody(exchange));
        }
        summary.append(ExchangeFormatter.indent(0) + "------ End Message Trace -------");
        return summary.toString();
    }

    private static String formatHeaders(Exchange exchange) {
        StringBuilder headers = new StringBuilder().append(ExchangeFormatter.indent(0) + "Consumer -> " + exchange.getConsumer().getName()).append(ExchangeFormatter.indent(0) + "Provider -> " + (exchange.getProvider() == null ? "[unassigned]" : exchange.getProvider().getName())).append(ExchangeFormatter.indent(0) + "Operation -> " + exchange.getContract().getConsumerOperation().getName()).append(ExchangeFormatter.indent(0) + "MEP -> " + (exchange.getContract().getConsumerOperation().getExchangePattern() == null ? "[unassigned]" : exchange.getContract().getConsumerOperation().getExchangePattern())).append(ExchangeFormatter.indent(0) + "Phase -> " + exchange.getPhase()).append(ExchangeFormatter.indent(0) + "State -> " + exchange.getState());
        headers.append(ExchangeFormatter.indent(0) + "Exchange Context -> ");
        ExchangeFormatter.dumpContext(headers, exchange.getContext().getProperties(Scope.EXCHANGE));
        headers.append(ExchangeFormatter.indent(0) + "Message Context -> ");
        ExchangeFormatter.dumpContext(headers, exchange.getContext().getProperties(Scope.MESSAGE));
        return headers.toString();
    }

    private static String formatBody(Exchange exchange) {
        String content;
        StringBuilder body;
        block5: {
            body = new StringBuilder();
            content = null;
            try {
                Message msg = exchange.getMessage();
                content = (String)msg.getContent(String.class);
                if (InputStream.class.isAssignableFrom(msg.getContent().getClass())) {
                    msg.setContent((Object)new ByteArrayInputStream(content.getBytes()));
                } else if (Reader.class.isAssignableFrom(msg.getContent().getClass())) {
                    msg.setContent((Object)new StringReader(content));
                }
            }
            catch (Exception ex) {
                if (exchange.getMessage().getContent() == null) break block5;
                content = exchange.getMessage().getContent().toString();
            }
        }
        body.append(ExchangeFormatter.indent(0) + "Message Content -> ").append(ExchangeFormatter.indent(0) + content);
        return body.toString();
    }

    private static void dumpContext(StringBuilder summary, Set<Property> properties) {
        TreeSet<Property> orderedProperties = new TreeSet<Property>(new Comparator<Property>(){

            @Override
            public int compare(Property p1, Property p2) {
                return p1.getName().compareTo(p2.getName());
            }
        });
        int maxLength = 0;
        for (Property property : properties) {
            int curLength = property.getName().length();
            if (curLength > maxLength) {
                maxLength = curLength;
            }
            orderedProperties.add(property);
        }
        for (Property orderedProperty : orderedProperties) {
            String name = orderedProperty.getName();
            int difLength = maxLength - name.length();
            String pad = difLength > 0 ? Strings.repeat((String)".", (int)difLength) : "";
            summary.append(ExchangeFormatter.indent(1) + name + " " + pad + ": " + orderedProperty.getValue());
        }
    }

    private static String indent(int column) {
        return INDENT + Strings.repeat((String)"    ", (int)column);
    }

    private ExchangeFormatter() {
    }
}

