/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.xml;

import java.util.ArrayList;
import java.util.List;
import org.switchyard.common.xml.Element;
import org.switchyard.common.xml.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IdentitySAXHandler
extends DefaultHandler {
    private Element _rootElement;
    private Element _currentElement;
    private List<Element> _stack = new ArrayList<Element>();
    private StringBuilder _currentText = new StringBuilder();

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        this.checkText();
        Element element = new Element(uri, localName, attributes);
        if (this._rootElement == null) {
            this._rootElement = element;
        }
        if (this._currentElement != null) {
            this._currentElement.addChild(element);
            this._stack.add(this._currentElement);
        }
        this._currentElement = element;
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        this.checkText();
        int lastIndex = this._stack.size() - 1;
        this._currentElement = lastIndex < 0 ? null : this._stack.remove(lastIndex);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this._currentText.append(ch, start, length);
    }

    private void checkText() {
        int textLength = this._currentText.length();
        if (textLength > 0) {
            int end;
            int start;
            for (start = 0; start < textLength && this.isXMLWhitespace(this._currentText.charAt(start)); ++start) {
            }
            for (end = textLength - 1; end >= start && this.isXMLWhitespace(this._currentText.charAt(end)); --end) {
            }
            if (start <= end) {
                this._currentElement.addChild(new Text(this._currentText.substring(start, end + 1)));
            }
            this._currentText.setLength(0);
            this._currentText.trimToSize();
        }
    }

    private boolean isXMLWhitespace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n';
    }

    public Element getRootElement() {
        return this._rootElement;
    }
}

