/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.bus.camel.audit;

import java.util.List;
import org.apache.camel.Exchange;
import org.jboss.logging.Logger;
import org.switchyard.bus.camel.audit.Auditor;
import org.switchyard.bus.camel.processors.Processors;

public class CompositeAuditor
implements Auditor {
    private Logger _logger = Logger.getLogger(CompositeAuditor.class);
    private final List<Auditor> _auditors;

    public CompositeAuditor(List<Auditor> auditors) {
        this._auditors = auditors;
    }

    @Override
    public void beforeCall(Processors processor, Exchange exchange) {
        for (Auditor auditor : this._auditors) {
            try {
                auditor.beforeCall(processor, exchange);
            }
            catch (Exception e) {
                this._logger.error((Object)e);
            }
        }
    }

    @Override
    public void afterCall(Processors processor, Exchange exchange) {
        for (Auditor auditor : this._auditors) {
            try {
                auditor.afterCall(processor, exchange);
            }
            catch (Exception e) {
                this._logger.error((Object)e);
            }
        }
    }
}

