/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.serial.graph.node;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import org.switchyard.serial.graph.Graph;
import org.switchyard.serial.graph.node.Node;
import org.switchyard.serial.graph.node.NodeBuilder;

public final class DataSourceNode
implements Node {
    private String _name;
    private String _contentType;
    private Integer _inputStreamId;

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getContentType() {
        return this._contentType;
    }

    public void setContentType(String contentType) {
        this._contentType = contentType;
    }

    public Integer getInputStreamId() {
        return this._inputStreamId;
    }

    public void setInputStreamId(Integer inputStreamId) {
        this._inputStreamId = inputStreamId;
    }

    @Override
    public void compose(Object obj, Graph graph) {
        DataSource ds = (DataSource)obj;
        this.setName(ds.getName());
        this.setContentType(ds.getContentType());
        try {
            this.setInputStreamId(NodeBuilder.build(ds.getInputStream(), graph));
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public Object decompose(Graph graph) {
        InputStream is = (InputStream)graph.decomposeReference(this.getInputStreamId());
        return new NodeDataSource(this.getName(), this.getContentType(), is);
    }

    private static final class NodeDataSource
    implements DataSource {
        private String _name;
        private String _contentType;
        private InputStream _inputStream;

        public NodeDataSource(String name, String contentType, InputStream inputStream) {
            this._name = name;
            this._contentType = contentType;
            this._inputStream = inputStream;
        }

        public String getName() {
            return this._name;
        }

        public String getContentType() {
            return this._contentType;
        }

        public InputStream getInputStream() throws IOException {
            return this._inputStream;
        }

        public OutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

