/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.scheduler.simple.jdbc;

import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.dao.scheduler.DatabaseException;
import org.apache.ode.dao.scheduler.JobDAO;
import org.apache.ode.dao.scheduler.SchedulerDAOConnection;
import org.apache.ode.scheduler.simple.jdbc.JobDAOImpl;
import org.apache.ode.utils.DbIsolation;
import org.apache.ode.utils.GUID;
import org.apache.ode.utils.StreamUtils;

public class SchedulerDAOConnectionImpl
implements SchedulerDAOConnection {
    private static final Log __log = LogFactory.getLog(SchedulerDAOConnectionImpl.class);
    private static final String DELETE_JOB = "delete from ODE_JOB where jobid = ? and nodeid = ?";
    private static final String UPDATE_REASSIGN = "update ODE_JOB set nodeid = ?, scheduled = false where nodeid = ?";
    private static final String UPDATE_JOB = "update ODE_JOB set ts = ?, retryCount = ?, scheduled = ? where jobid = ?";
    private static final String UPGRADE_JOB_DEFAULT = "update ODE_JOB set nodeid = ? where nodeid is null and scheduled = false and mod(ts,?) = ? and ts < ?";
    private static final String UPGRADE_JOB_DB2 = "update ODE_JOB set nodeid = ? where nodeid is null and scheduled = false and mod(ts,CAST(? AS BIGINT)) = ? and ts < ?";
    private static final String UPGRADE_JOB_SQLSERVER = "update ODE_JOB set nodeid = ? where nodeid is null and scheduled = false and (ts % ?) = ? and ts < ?";
    private static final String UPGRADE_JOB_SYBASE = "update ODE_JOB set nodeid = ? where nodeid is null and scheduled = false and convert(int, ts) % ? = ? and ts < ?";
    private static final String UPGRADE_JOB_SYBASE12 = "update ODE_JOB set nodeid = ? where nodeid is null and scheduled = false and -1 <> ? and -1 <> ? and ts < ?";
    private static final String SAVE_JOB = "insert into ODE_JOB  (jobid, nodeid, ts, scheduled, transacted, instanceId,mexId,processId,type,channel,correlatorId,correlationKeySet,retryCount,inMem,detailsExt) values(?, ?, ?, ?, ?,?,?,?,?,?,?,?,?,?,?)";
    private static final String GET_NODEIDS = "select distinct nodeid from ODE_JOB";
    private static final String SCHEDULE_IMMEDIATE = "select jobid, ts, transacted, scheduled, instanceId,mexId,processId,type,channel,correlatorId,correlationKeySet,retryCount,inMem,detailsExt from ODE_JOB where nodeid = ? and scheduled = false and ts < ? order by ts";
    private static final String UPDATE_SCHEDULED = "update ODE_JOB set scheduled = true where jobid in (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final int UPDATE_SCHEDULED_SLOTS = 10;
    private DataSource _ds;
    private Dialect _dialect;
    private AtomicBoolean _active;
    private TransactionManager _txm;

    public SchedulerDAOConnectionImpl(AtomicBoolean active, DataSource ds, TransactionManager txm) {
        this._active = active;
        this._ds = ds;
        this._txm = txm;
        this._dialect = this.guessDialect();
    }

    public boolean deleteJob(String jobid, String nodeId) throws DatabaseException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("deleteJob " + jobid + " on node " + nodeId));
        }
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = con.prepareStatement(DELETE_JOB);
            ps.setString(1, jobid);
            ps.setString(2, nodeId);
            boolean bl = ps.executeUpdate() == 1;
            this.close(ps);
            this.close(con);
            return bl;
        }
        catch (SQLException se) {
            try {
                throw new DatabaseException((Exception)se);
            }
            catch (Throwable throwable) {
                this.close(ps);
                this.close(con);
                throw throwable;
            }
        }
    }

    public List<String> getNodeIds() throws DatabaseException {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = con.prepareStatement(GET_NODEIDS, 1003, 1007);
            ResultSet rs = ps.executeQuery();
            ArrayList<String> nodes = new ArrayList<String>();
            while (rs.next()) {
                String nodeId = rs.getString(1);
                if (nodeId == null) continue;
                nodes.add(rs.getString(1));
            }
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("getNodeIds: " + nodes));
            }
            ArrayList<String> arrayList = nodes;
            this.close(ps);
            this.close(con);
            return arrayList;
        }
        catch (SQLException se) {
            try {
                throw new DatabaseException((Exception)se);
            }
            catch (Throwable throwable) {
                this.close(ps);
                this.close(con);
                throw throwable;
            }
        }
    }

    public boolean insertJob(JobDAO job, String nodeId, boolean loaded) throws DatabaseException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("insertJob " + job.getJobId() + " on node " + nodeId + " loaded=" + loaded));
        }
        Connection con = null;
        PreparedStatement ps = null;
        try {
            int i = 1;
            con = this.getConnection();
            ps = con.prepareStatement(SAVE_JOB);
            ps.setString(i++, job.getJobId());
            ps.setString(i++, nodeId);
            ps.setLong(i++, job.getScheduledDate());
            ps.setBoolean(i++, loaded);
            ps.setBoolean(i++, job.isTransacted());
            Scheduler.JobDetails details = job.getDetails();
            ps.setObject(i++, (Object)details.instanceId, -5);
            ps.setObject(i++, (Object)details.mexId, 12);
            ps.setObject(i++, (Object)details.processId, 12);
            ps.setObject(i++, (Object)details.type, 12);
            ps.setObject(i++, (Object)details.channel, 12);
            ps.setObject(i++, (Object)details.correlatorId, 12);
            ps.setObject(i++, (Object)details.correlationKeySet, 12);
            ps.setObject(i++, (Object)details.retryCount, 4);
            ps.setObject(i++, (Object)details.inMem, 16);
            if (details.detailsExt == null || details.detailsExt.size() == 0) {
                ps.setObject(i++, null, 2004);
            } else {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                try {
                    StreamUtils.write((OutputStream)bos, (Serializable)((Serializable)((Object)details.detailsExt)));
                }
                catch (Exception ex) {
                    __log.error((Object)("Error serializing job detail: " + job.getDetails()));
                    throw new DatabaseException(ex);
                }
                ps.setObject(i++, (Object)bos.toByteArray(), 2004);
            }
            boolean bl = ps.executeUpdate() == 1;
            this.close(ps);
            this.close(con);
            return bl;
        }
        catch (SQLException se) {
            try {
                throw new DatabaseException((Exception)se);
            }
            catch (Throwable throwable) {
                this.close(ps);
                this.close(con);
                throw throwable;
            }
        }
    }

    public boolean updateJob(JobDAO job) throws DatabaseException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("updateJob " + job.getJobId() + " retryCount=" + job.getDetails().getRetryCount()));
        }
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = con.prepareStatement(UPDATE_JOB);
            ps.setLong(1, job.getScheduledDate());
            ps.setInt(2, job.getDetails().getRetryCount());
            ps.setBoolean(3, job.isScheduled());
            ps.setString(4, job.getJobId());
            boolean bl = ps.executeUpdate() == 1;
            this.close(ps);
            this.close(con);
            return bl;
        }
        catch (SQLException se) {
            try {
                throw new DatabaseException((Exception)se);
            }
            catch (Throwable throwable) {
                this.close(ps);
                this.close(con);
                throw throwable;
            }
        }
    }

    private Long asLong(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).longValue();
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Integer) {
            return ((Integer)o).longValue();
        }
        throw new IllegalStateException("Can't convert to long " + o.getClass());
    }

    private Integer asInteger(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).intValue();
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        throw new IllegalStateException("Can't convert to integer " + o.getClass());
    }

    public List<JobDAO> dequeueImmediate(String nodeId, long maxtime, int maxjobs) throws DatabaseException {
        ArrayList<JobDAO> ret = new ArrayList<JobDAO>(maxjobs);
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = con.prepareStatement(SCHEDULE_IMMEDIATE);
            ps.setString(1, nodeId);
            ps.setLong(2, maxtime);
            ps.setMaxRows(maxjobs);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Map detailsExt;
                Scheduler.JobDetails details = new Scheduler.JobDetails();
                details.instanceId = this.asLong(rs.getObject("instanceId"));
                details.mexId = (String)rs.getObject("mexId");
                details.processId = (String)rs.getObject("processId");
                details.type = (String)rs.getObject("type");
                details.channel = (String)rs.getObject("channel");
                details.correlatorId = (String)rs.getObject("correlatorId");
                details.correlationKeySet = (String)rs.getObject("correlationKeySet");
                details.retryCount = this.asInteger(rs.getObject("retryCount"));
                details.inMem = rs.getBoolean("inMem");
                if (rs.getObject("detailsExt") != null) {
                    try {
                        ObjectInputStream is = new ObjectInputStream(rs.getBinaryStream("detailsExt"));
                        details.detailsExt = (Map)is.readObject();
                        is.close();
                    }
                    catch (Exception e) {
                        throw new DatabaseException("Error deserializing job detailsExt", e);
                    }
                }
                if ((detailsExt = details.getDetailsExt()).get("type") != null) {
                    details.type = (String)detailsExt.get("type");
                }
                if (detailsExt.get("iid") != null) {
                    details.instanceId = (Long)detailsExt.get("iid");
                }
                if (detailsExt.get("pid") != null) {
                    details.processId = (String)detailsExt.get("pid");
                }
                if (detailsExt.get("inmem") != null) {
                    details.inMem = (Boolean)detailsExt.get("inmem");
                }
                if (detailsExt.get("ckey") != null) {
                    details.correlationKeySet = (String)detailsExt.get("ckey");
                }
                if (detailsExt.get("channel") != null) {
                    details.channel = (String)detailsExt.get("channel");
                }
                if (detailsExt.get("mexid") != null) {
                    details.mexId = (String)detailsExt.get("mexid");
                }
                if (detailsExt.get("correlatorId") != null) {
                    details.correlatorId = (String)detailsExt.get("correlatorId");
                }
                if (detailsExt.get("retryCount") != null) {
                    details.retryCount = Integer.parseInt((String)detailsExt.get("retryCount"));
                }
                JobDAOImpl job = new JobDAOImpl(rs.getLong("ts"), rs.getString("jobid"), rs.getBoolean("transacted"), details);
                ret.add(job);
            }
            rs.close();
            ps.close();
            int j = 0;
            int updateCount = 0;
            ps = con.prepareStatement(UPDATE_SCHEDULED);
            for (int updates = 1; updates <= ret.size() / 10 + 1; ++updates) {
                for (int i = 1; i <= 10; ++i) {
                    ps.setString(i, j < ret.size() ? ret.get(j).getJobId() : "");
                    ++j;
                }
                ps.execute();
                updateCount += ps.getUpdateCount();
            }
            if (updateCount != ret.size()) {
                __log.error((Object)("Updating scheduled jobs failed to update all jobs; expected=" + ret.size() + " actual=" + updateCount));
                List<JobDAO> list = null;
                this.close(ps);
                this.close(con);
                return list;
            }
            this.close(ps);
            this.close(con);
        }
        catch (SQLException se) {
            try {
                throw new DatabaseException((Exception)se);
            }
            catch (Throwable throwable) {
                this.close(ps);
                this.close(con);
                throw throwable;
            }
        }
        return ret;
    }

    public int updateReassign(String oldnode, String newnode) throws DatabaseException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("updateReassign from " + oldnode + " ---> " + newnode));
        }
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = con.prepareStatement(UPDATE_REASSIGN);
            ps.setString(1, newnode);
            ps.setString(2, oldnode);
            int n = ps.executeUpdate();
            this.close(ps);
            this.close(con);
            return n;
        }
        catch (SQLException se) {
            try {
                throw new DatabaseException((Exception)se);
            }
            catch (Throwable throwable) {
                this.close(ps);
                this.close(con);
                throw throwable;
            }
        }
    }

    public int updateAssignToNode(String node, int i, int numNodes, long maxtime) throws DatabaseException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("updateAsssignToNode node=" + node + " " + i + "/" + numNodes + " maxtime=" + maxtime));
        }
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = this._dialect == Dialect.SQLSERVER ? con.prepareStatement(UPGRADE_JOB_SQLSERVER) : (this._dialect == Dialect.DB2 ? con.prepareStatement(UPGRADE_JOB_DB2) : (this._dialect == Dialect.SYBASE ? con.prepareStatement(UPGRADE_JOB_SYBASE) : (this._dialect == Dialect.SYBASE12 ? con.prepareStatement(UPGRADE_JOB_SYBASE12) : con.prepareStatement(UPGRADE_JOB_DEFAULT))));
            ps.setString(1, node);
            ps.setInt(2, numNodes);
            ps.setInt(3, i);
            ps.setLong(4, maxtime);
            int n = ps.executeUpdate();
            this.close(ps);
            this.close(con);
            return n;
        }
        catch (SQLException se) {
            try {
                throw new DatabaseException((Exception)se);
            }
            catch (Throwable throwable) {
                this.close(ps);
                this.close(con);
                throw throwable;
            }
        }
    }

    private Connection getConnection() throws SQLException {
        Connection c = this._ds.getConnection();
        DbIsolation.setIsolationLevel((Connection)c);
        return c;
    }

    private void close(PreparedStatement ps) {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (Exception e) {
                __log.warn((Object)"Exception while closing prepared statement", (Throwable)e);
            }
        }
    }

    private void close(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (Exception e) {
                __log.warn((Object)"Exception while closing connection", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dialect guessDialect() {
        Dialect d = Dialect.UNKNOWN;
        Connection con = null;
        try {
            con = this.getConnection();
            DatabaseMetaData metaData = con.getMetaData();
            if (metaData != null) {
                String dbProductName = metaData.getDatabaseProductName();
                int dbMajorVer = metaData.getDatabaseMajorVersion();
                __log.debug((Object)("Using database " + dbProductName + " major version " + dbMajorVer));
                if (dbProductName.indexOf("DB2") >= 0) {
                    d = Dialect.DB2;
                } else if (dbProductName.indexOf("Derby") >= 0) {
                    d = Dialect.DERBY;
                } else if (dbProductName.indexOf("Firebird") >= 0) {
                    d = Dialect.FIREBIRD;
                } else if (dbProductName.indexOf("HSQL") >= 0) {
                    d = Dialect.HSQL;
                } else if (dbProductName.indexOf("Microsoft SQL") >= 0) {
                    d = Dialect.SQLSERVER;
                } else if (dbProductName.indexOf("MySQL") >= 0) {
                    d = Dialect.MYSQL;
                } else if (dbProductName.indexOf("Sybase") >= 0 || dbProductName.indexOf("ASE") >= 0 || dbProductName.indexOf("Adaptive") >= 0) {
                    d = Dialect.SYBASE;
                    if (dbMajorVer >= 12) {
                        d = Dialect.SYBASE12;
                    }
                }
            }
        }
        catch (SQLException e) {
            __log.warn((Object)"Unable to determine database dialect", (Throwable)e);
        }
        finally {
            this.close(con);
        }
        __log.debug((Object)("Using database dialect: " + (Object)((Object)d)));
        return d;
    }

    public void close() {
    }

    public boolean isClosed() {
        return this._active.get();
    }

    public JobDAO createJob(String jobid, boolean transacted, Scheduler.JobDetails jobDetails, boolean persisted, long scheduledDate) {
        return new JobDAOImpl(scheduledDate, jobid, transacted, jobDetails);
    }

    public JobDAO createJob(boolean transacted, Scheduler.JobDetails jobDetails, boolean persisted, long scheduledDate) {
        return this.createJob(new GUID().toString(), transacted, jobDetails, persisted, scheduledDate);
    }

    static enum Dialect {
        DB2,
        DERBY,
        FIREBIRD,
        HSQL,
        MYSQL,
        ORACLE,
        SQLSERVER,
        SYBASE,
        SYBASE12,
        UNKNOWN;

    }
}

