/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.cdr.extension;

import org.milyn.SmooksException;
import org.milyn.cdr.Parameter;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.extension.ExtensionContext;
import org.milyn.container.ExecutionContext;
import org.milyn.javabean.expression.BeanMapExpressionEvaluator;
import org.w3c.dom.Element;

public abstract class ResourceConfigUtil {
    public static void setProperty(SmooksResourceConfiguration config, String setOn, String value, Element xml, ExecutionContext executionContext) throws SmooksException {
        if (setOn.equals("selector")) {
            config.setSelector(value);
        } else if (setOn.equals("resource")) {
            config.setResource(value);
        } else if (setOn.equals("resourceType")) {
            config.setResourceType(value);
        } else if (setOn.equals("selector-namespace")) {
            config.setSelectorNamespaceURI(value);
        } else if (setOn.equals("defaultResource")) {
            config.setDefaultResource(Boolean.parseBoolean(value));
        } else if (setOn.equals("targetProfile")) {
            config.setTargetProfile(value);
        } else if (setOn.equals("condition") && value.length() > 0) {
            config.setConditionEvaluator(new BeanMapExpressionEvaluator(value));
        } else if (setOn.equals("conditionRef")) {
            ExtensionContext execentionContext = ExtensionContext.getExtensionContext(executionContext);
            config.setConditionEvaluator(execentionContext.getXmlConfigDigester().getConditionEvaluator(value));
        } else {
            Parameter param = config.setParameter(setOn, value);
            if (xml != null) {
                param.setXML(xml);
            }
        }
    }

    public static void setProperty(SmooksResourceConfiguration config, String setOn, String value, ExecutionContext executionContext) throws SmooksException {
        ResourceConfigUtil.setProperty(config, setOn, value, null, executionContext);
    }

    public static void unsetProperty(SmooksResourceConfiguration config, String property) {
        if (property.equals("selector")) {
            config.setSelector(null);
        } else if (property.equals("resource")) {
            config.setResource(null);
        } else if (property.equals("resourceType")) {
            config.setResourceType(null);
        } else if (property.equals("selector-namespace")) {
            config.setSelectorNamespaceURI(null);
        } else if (property.equals("defaultResource")) {
            config.setDefaultResource(false);
        } else if (property.equals("targetProfile")) {
            config.setTargetProfile(null);
        } else if (property.equals("condition")) {
            config.setConditionEvaluator(null);
        } else if (property.equals("conditionRef")) {
            config.setConditionEvaluator(null);
        } else {
            config.removeParameter(property);
        }
    }

    public static void mapProperty(SmooksResourceConfiguration fromConfig, String fromProperty, SmooksResourceConfiguration toConfig, String toProperty, String defaultValue, ExecutionContext executionContext) throws SmooksException {
        if (fromProperty.equals("selector")) {
            ResourceConfigUtil.setProperty(toConfig, toProperty, fromConfig.getSelector(), executionContext);
        } else if (fromProperty.equals("resource")) {
            ResourceConfigUtil.setProperty(toConfig, toProperty, fromConfig.getResource(), executionContext);
        } else if (fromProperty.equals("resourceType")) {
            ResourceConfigUtil.setProperty(toConfig, toProperty, fromConfig.getResourceType(), executionContext);
        } else if (fromProperty.equals("selector-namespace")) {
            ResourceConfigUtil.setProperty(toConfig, toProperty, fromConfig.getSelectorNamespaceURI(), executionContext);
        } else if (fromProperty.equals("defaultResource")) {
            ResourceConfigUtil.setProperty(toConfig, toProperty, Boolean.toString(fromConfig.isDefaultResource()), executionContext);
        } else if (fromProperty.equals("targetProfile")) {
            ResourceConfigUtil.setProperty(toConfig, toProperty, fromConfig.getTargetProfile(), executionContext);
        } else if (fromProperty.equals("condition")) {
            toConfig.setConditionEvaluator(fromConfig.getConditionEvaluator());
        } else if (fromProperty.equals("conditionRef")) {
            toConfig.setConditionEvaluator(fromConfig.getConditionEvaluator());
        } else {
            ResourceConfigUtil.setProperty(toConfig, toProperty, fromConfig.getStringParameter(fromProperty, defaultValue), executionContext);
        }
    }
}

