/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.epr;

import java.util.HashMap;
import java.util.Map;
import org.apache.ode.bpel.epr.MutableEndpoint;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.Namespaces;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class URLEndpoint
implements MutableEndpoint {
    private String _url;

    @Override
    public String getUrl() {
        return this._url != null ? this._url.trim() : null;
    }

    public void setUrl(String url) {
        this._url = url;
    }

    @Override
    public boolean accept(Node node) {
        if (node.getNodeType() == 3) {
            return true;
        }
        if (node.getNodeType() == 1) {
            Element elmt = (Element)node;
            if (elmt.getLocalName().equals("address") && elmt.getNamespaceURI().equals(Namespaces.SOAP_NS)) {
                return true;
            }
            if (elmt.getLocalName().equals("service-ref") && (elmt.getNamespaceURI().equals(Namespaces.WS_BPEL_20_NS) || elmt.getNamespaceURI().equals(Namespaces.WSBPEL2_0_FINAL_SERVREF))) {
                if (DOMUtils.getFirstChildElement((Element)elmt) == null) {
                    return true;
                }
                if ((elmt = DOMUtils.getFirstChildElement((Element)elmt)).getLocalName().equals("address") && elmt.getNamespaceURI().equals(Namespaces.SOAP_NS)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void set(Node node) {
        if (node.getNodeType() == 3) {
            this._url = ((Text)node).getWholeText();
        } else if (node.getNodeType() == 1) {
            Element elmt = (Element)node;
            if (elmt.getNamespaceURI().equals(Namespaces.SOAP_NS)) {
                this._url = elmt.getAttribute("location");
            } else if (elmt.getNamespaceURI().equals(Namespaces.WS_BPEL_20_NS) || elmt.getNamespaceURI().equals(Namespaces.WSBPEL2_0_FINAL_SERVREF)) {
                if (DOMUtils.getFirstChildElement((Element)elmt) == null) {
                    this._url = elmt.getTextContent();
                } else {
                    elmt = DOMUtils.getFirstChildElement((Element)elmt);
                    this._url = elmt.getAttribute("location");
                }
            }
        }
    }

    public Document toXML() {
        Document doc = DOMUtils.newDocument();
        Element serviceRef = doc.createElementNS(SERVICE_REF_QNAME.getNamespaceURI(), SERVICE_REF_QNAME.getLocalPart());
        doc.appendChild(serviceRef);
        Text urlNode = doc.createTextNode(this._url);
        serviceRef.appendChild(urlNode);
        return doc;
    }

    @Override
    public Map toMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("address", this._url);
        return result;
    }

    @Override
    public void fromMap(Map eprMap) {
        this._url = (String)eprMap.get("address");
    }
}

