/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.version;

import org.switchyard.common.version.BaseVersion;
import org.switchyard.common.version.Specification;

public class BaseSpecification
implements Specification {
    private final String _title;
    private final String _vendor;
    private final String _version;

    public BaseSpecification(String title, String vendor, String version) {
        this._title = title;
        this._vendor = vendor;
        this._version = version;
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    @Override
    public String getVendor() {
        return this._vendor;
    }

    @Override
    public String getVersion() {
        return this._version;
    }

    public String toString() {
        return String.format("%s [title=%s, vendor=%s, version=%s]", Specification.class.getSimpleName(), this.getTitle(), this.getVendor(), this.getVersion());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseSpecification other = (BaseSpecification)obj;
        if (this._title == null ? other._title != null : !this._title.equals(other._title)) {
            return false;
        }
        if (this._vendor == null ? other._vendor != null : !this._vendor.equals(other._vendor)) {
            return false;
        }
        return !(this._version == null ? other._version != null : !this._version.equals(other._version));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._title == null ? 0 : this._title.hashCode());
        result = 31 * result + (this._vendor == null ? 0 : this._vendor.hashCode());
        result = 31 * result + (this._version == null ? 0 : this._version.hashCode());
        return result;
    }

    @Override
    public int compareTo(Specification that) {
        int comparison = 0;
        if (this != that && (comparison = BaseVersion.compare(this._title, that.getTitle())) == 0 && (comparison = BaseVersion.compare(this._vendor, that.getVendor())) == 0) {
            comparison = BaseVersion.compare(this._version, that.getVersion());
        }
        return comparison;
    }
}

