/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.bus.camel;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.switchyard.Property;

public abstract class CamelPropertyBase
implements Property {
    public Set<String> getLabels() {
        Set<String> labels = this.getLabelsBag().get(this.getName());
        if (labels == null) {
            labels = Collections.emptySet();
        }
        return labels;
    }

    public Property addLabels(String ... labels) {
        if (!this.getLabelsBag().containsKey(this.getName())) {
            this.getLabelsBag().put(this.getName(), new HashSet());
        }
        this.getLabelsBag().get(this.getName()).addAll(Arrays.asList(labels));
        return this;
    }

    public Property addLabels(Set<String> labels) {
        if (!this.getLabelsBag().containsKey(this.getName())) {
            this.getLabelsBag().put(this.getName(), new HashSet());
        }
        this.getLabelsBag().get(this.getName()).addAll(labels);
        return this;
    }

    public Property removeLabels(String ... labels) {
        if (this.getLabelsBag().containsKey(this.getName())) {
            this.getLabelsBag().get(this.getName()).removeAll(Arrays.asList(labels));
        }
        return this;
    }

    public boolean hasLabel(String label) {
        return this.getLabelsBag().containsKey(this.getName()) ? this.getLabelsBag().get(this.getName()).contains(label) : false;
    }

    protected abstract Map<String, Set<String>> getLabelsBag();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.getScope() == null ? 0 : this.getScope().hashCode());
        result = 31 * result + (this.getValue() == null ? 0 : this.getValue().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Property other = (Property)obj;
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        if (this.getScope() != other.getScope()) {
            return false;
        }
        return !(this.getValue() == null ? other.getValue() != null : !this.getValue().equals(other.getValue()));
    }
}

