/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.common.composer;

import org.apache.camel.CamelContext;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.spi.FactoryFinder;
import org.switchyard.component.camel.common.CommonCamelMessages;
import org.switchyard.component.camel.common.composer.BindingDataCreator;
import org.switchyard.component.camel.common.composer.DefaultBindingDataCreator;

public class BindingDataCreatorResolver {
    private static final String BINDING_DATA_CREATOR_RESOURCE_PATH = "META-INF/services/org/switchyard/component/camel/";
    private FactoryFinder _bindingDataCreatorFactory;

    public BindingDataCreator<?> resolveBindingCreator(String name, CamelContext context) {
        Class type = null;
        try {
            if (this._bindingDataCreatorFactory == null) {
                this._bindingDataCreatorFactory = context.getFactoryFinder(BINDING_DATA_CREATOR_RESOURCE_PATH);
            }
            type = this._bindingDataCreatorFactory.findClass(name);
        }
        catch (NoFactoryAvailableException e) {
            e.getMessage();
        }
        catch (Exception e) {
            throw CommonCamelMessages.MESSAGES.invalidURINoBindingDataCreatorRegisteredForScheme(name, e);
        }
        if (type != null) {
            if (BindingDataCreator.class.isAssignableFrom(type)) {
                return (BindingDataCreator)context.getInjector().newInstance(type);
            }
            throw CommonCamelMessages.MESSAGES.resolvingBindingDataCreatorForEndpointOfType(name, type.getName());
        }
        return new DefaultBindingDataCreator();
    }
}

