/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.cli;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ode.utils.cli.CommandlineFragment;
import org.apache.ode.utils.cli.CommandlineSyntaxException;

public class XorGroup
implements CommandlineFragment {
    private List<CommandlineFragment> _frags = new ArrayList<CommandlineFragment>();
    private CommandlineFragment _matched;
    private boolean _isOptional;
    private String _description;

    public XorGroup(String description, boolean optional) {
        this._description = description;
        this._isOptional = optional;
    }

    @Override
    public void reset() {
        this._matched = null;
        Iterator<CommandlineFragment> it = this._frags.iterator();
        while (it.hasNext()) {
            it.next().reset();
        }
    }

    public void addFragment(CommandlineFragment frag) {
        this._frags.add(frag);
    }

    public boolean didMatch() {
        return this._matched != null;
    }

    public CommandlineFragment getMatched() {
        return this._matched;
    }

    @Override
    public List<String> consume(List<String> s) throws CommandlineSyntaxException {
        List<String> l = null;
        for (CommandlineFragment cf : this._frags) {
            try {
                l = cf.consume(s);
            }
            catch (CommandlineSyntaxException cse) {
                continue;
            }
            if (this._matched == null) {
                this._matched = cf;
                continue;
            }
            throw new CommandlineSyntaxException("Multiple possibilities matched from " + this.getUsage() + ".");
        }
        if (this._matched == null) {
            if (!this.isOptional()) {
                throw new CommandlineSyntaxException("No possibility matched from " + this.getUsage() + ".");
            }
            return new ArrayList<String>(s);
        }
        return l;
    }

    @Override
    public String getUsage() {
        StringBuffer sb = new StringBuffer();
        Iterator<CommandlineFragment> it = this._frags.iterator();
        while (it.hasNext()) {
            if (sb.length() != 0) {
                sb.append('|');
            }
            sb.append(it.next().getUsage());
        }
        return sb.toString();
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public boolean isOptional() {
        return this._isOptional;
    }
}

