/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.dozer.internal;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.switchyard.ServiceDomain;
import org.switchyard.common.xml.QNameUtil;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.config.model.DozerFileEntryModel;
import org.switchyard.transform.config.model.DozerMappingFilesModel;
import org.switchyard.transform.config.model.DozerTransformModel;
import org.switchyard.transform.dozer.internal.DozerTransformer;
import org.switchyard.transform.internal.TransformMessages;
import org.switchyard.transform.internal.TransformerFactory;

public class DozerTransformFactory
implements TransformerFactory<DozerTransformModel> {
    @Override
    public Transformer<?, ?> newTransformer(ServiceDomain domain, DozerTransformModel model) {
        QName from = model.getFrom();
        QName to = model.getTo();
        if (from == null || !QNameUtil.isJavaMessageType((QName)from)) {
            throw TransformMessages.MESSAGES.invalidFromTypeForDozerTransformer(from);
        }
        if (to == null || !QNameUtil.isJavaMessageType((QName)to)) {
            throw TransformMessages.MESSAGES.invalidToTypeForDozerTransformer(to);
        }
        ArrayList<String> mappingFiles = new ArrayList<String>();
        DozerMappingFilesModel files = model.getDozerMappingFiles();
        if (files != null) {
            for (DozerFileEntryModel entry : files.getEntries()) {
                String filename = entry.getFile();
                if (filename == null || filename.isEmpty()) continue;
                mappingFiles.add(filename);
            }
        }
        return new DozerTransformer(from, to, mappingFiles);
    }
}

