/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.xslt.internal;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import org.switchyard.ServiceDomain;
import org.switchyard.common.type.Classes;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.config.model.XsltTransformModel;
import org.switchyard.transform.internal.TransformLogger;
import org.switchyard.transform.internal.TransformMessages;
import org.switchyard.transform.internal.TransformerFactory;
import org.switchyard.transform.xslt.internal.XsltTransformer;
import org.switchyard.transform.xslt.internal.XsltUriResolver;

public final class XsltTransformFactory
implements TransformerFactory<XsltTransformModel> {
    public static final String MAX_POOL_SIZE = "org.switchyard.transform.xslt.maxPoolSize";
    public static final int DEFAULT_MAX_POOL_SIZE = 50;

    @Override
    public Transformer newTransformer(ServiceDomain domain, XsltTransformModel model) {
        String xsltFileUri = model.getXsltFile();
        boolean failOnWarning = model.failOnWarning();
        QName to = model.getTo();
        QName from = model.getFrom();
        if (xsltFileUri == null || xsltFileUri.equals("")) {
            throw TransformMessages.MESSAGES.noXSLFileDefined();
        }
        try {
            InputStream stylesheetStream = Classes.getResourceAsStream((String)xsltFileUri);
            if (stylesheetStream == null) {
                TransformMessages.MESSAGES.failedToLoadXSLFile(xsltFileUri);
            }
            javax.xml.transform.TransformerFactory tFactory = javax.xml.transform.TransformerFactory.newInstance();
            tFactory.setErrorListener(new XsltTransformFactoryErrorListener(failOnWarning));
            tFactory.setURIResolver(new XsltUriResolver());
            Templates templates = tFactory.newTemplates(new StreamSource(stylesheetStream));
            return new XsltTransformer(from, to, templates, failOnWarning, this.getTransformPoolSize(model));
        }
        catch (TransformerConfigurationException e) {
            throw TransformMessages.MESSAGES.unexpectedErrorOcurred(e);
        }
        catch (IOException e) {
            throw TransformMessages.MESSAGES.unableToLocateXSLTFile(model.getXsltFile().toString(), e);
        }
    }

    int getTransformPoolSize(XsltTransformModel model) {
        String poolProp;
        SwitchYardModel syModel;
        int poolSize = 50;
        Model root = model.getModelRoot();
        if (root instanceof SwitchYardModel && (syModel = (SwitchYardModel)root).getDomain() != null && syModel.getDomain().getProperties() != null && (poolProp = syModel.getDomain().getProperties().getPropertyValue(MAX_POOL_SIZE)) != null) {
            poolSize = Integer.parseInt(poolProp);
        }
        return poolSize;
    }

    private class XsltTransformFactoryErrorListener
    implements ErrorListener {
        private boolean _failOnWarning;

        public XsltTransformFactoryErrorListener(boolean failOnWarning) {
            this._failOnWarning = failOnWarning;
        }

        @Override
        public void warning(TransformerException ex) throws TransformerException {
            if (this._failOnWarning) {
                throw ex;
            }
            TransformLogger.ROOT_LOGGER.warningDuringCompilation(ex);
        }

        @Override
        public void error(TransformerException ex) throws TransformerException {
            throw ex;
        }

        @Override
        public void fatalError(TransformerException ex) throws TransformerException {
            throw ex;
        }
    }
}

