/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.jca.processor;

import java.io.InputStream;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.Topic;
import javax.naming.InitialContext;
import org.jboss.logging.Logger;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.common.type.Classes;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.component.jca.JCALogger;
import org.switchyard.component.jca.JCAMessages;
import org.switchyard.component.jca.composer.JMSBindingData;
import org.switchyard.component.jca.processor.AbstractOutboundProcessor;

public class JMSProcessor
extends AbstractOutboundProcessor {
    public static final String CONTEXT_PROPERTY_PREFIX = "org.switchyard.component.jca.processor.";
    public static final String KEY_USERNAME = "userName";
    public static final String KEY_PASSWORD = "password";
    public static final String KEY_TRANSACTED = "transacted";
    public static final String KEY_ACKNOWLEDGE_MODE = "acknowledgeMode";
    public static final String KEY_DESTINATION_TYPE = "destinationType";
    public static final String KEY_DESTINATION = "destination";
    public static final String KEY_MESSAGE_TYPE = "messageType";
    public static final String KEY_DELIVERY_MODE = "deliveryMode";
    public static final String KEY_PRIORITY = "priority";
    public static final String KEY_TIME_TO_LIVE = "timeToLive";
    public static final String KEY_DESTINATION_JNDI_PROPERTIES_FILE = "destinationJndiPropertiesFileName";
    private Logger _logger = Logger.getLogger(JMSProcessor.class);
    private String _userName;
    private String _password;
    private String _transacted;
    private boolean _defaultTxEnabled;
    private DestinationType _defaultDestinationType = DestinationType.JNDI;
    private String _defaultDestination;
    private String _acknowledgeMode;
    private int _defaultAckMode;
    private ConnectionFactory _connectionFactory;
    private Destination _defaultJmsDestination;
    private MessageComposer<JMSBindingData> _composer;
    private MessageType _defaultOutMessageType = MessageType.Object;
    private String _destinationJndiPropertiesFileName;
    private Properties _destinationJndiProperties;

    @Override
    public AbstractOutboundProcessor setConnectionSpec(String name, Properties props) {
        return this;
    }

    @Override
    public AbstractOutboundProcessor setInteractionSpec(String name, Properties props) {
        return this;
    }

    @Override
    public void initialize() {
        this._defaultTxEnabled = Boolean.parseBoolean(this._transacted);
        this._defaultAckMode = this._acknowledgeMode == null || this._acknowledgeMode.equals("") ? 1 : Integer.parseInt(this._acknowledgeMode);
        if (this._defaultDestination == null) {
            throw JCAMessages.MESSAGES.destinationPropertyMustBeSpecifiedInProcessorProperties();
        }
        this._composer = this.getMessageComposer(JMSBindingData.class);
        try {
            InitialContext cfic = null;
            cfic = this.getJndiProperties() != null ? new InitialContext(this.getJndiProperties()) : new InitialContext();
            this._connectionFactory = (ConnectionFactory)cfic.lookup(this.getConnectionFactoryJNDIName());
            if (this._defaultDestinationType == DestinationType.JNDI) {
                InitialContext destic = null;
                if (this.getDestinationJndiProperties() != null) {
                    cfic.close();
                    destic = new InitialContext(this.getDestinationJndiProperties());
                } else {
                    destic = cfic;
                }
                this._defaultJmsDestination = (Destination)destic.lookup(this._defaultDestination);
                destic.close();
            }
        }
        catch (Exception e) {
            throw JCAMessages.MESSAGES.failedToInitialize(this.getClass().getName(), e);
        }
        if (this._logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder().append("Initialized with: {").append("Connection Factory:").append(this.getConnectionFactoryJNDIName()).append(", Destination Type:").append((Object)this._defaultDestinationType).append(", Destination Name:").append(this._defaultDestination).append(", User Name:").append(this._userName).append(", Output Message Type:").append((Object)this._defaultOutMessageType).append(", JNDI Properties File:").append(this.getJndiPropertiesFileName()).append(", Destination JNDI Properties File:").append(this._destinationJndiPropertiesFileName).append("}");
            this._logger.debug((Object)msg.toString());
        }
    }

    @Override
    public void uninitialize() {
        this._connectionFactory = null;
    }

    @Override
    public Message process(Exchange exchange) throws HandlerException {
        Connection connection = null;
        Session session = null;
        try {
            block24: {
                StreamMessage msg;
                connection = this._userName != null ? this._connectionFactory.createConnection(this._userName, this._password) : this._connectionFactory.createConnection();
                connection.start();
                Context context = exchange.getContext();
                session = connection.createSession(this.getTxEnabledFromContext(context), this.getAcknowledgeModeFromContext(context));
                MessageProducer producer = session.createProducer(this.getDestinationFromContext(session, context));
                switch (this.getOutputMessageTypeFromContext(context)) {
                    case Stream: {
                        msg = session.createStreamMessage();
                        break;
                    }
                    case Map: {
                        msg = session.createMapMessage();
                        break;
                    }
                    case Text: {
                        msg = session.createTextMessage();
                        break;
                    }
                    case Bytes: {
                        msg = session.createBytesMessage();
                        break;
                    }
                    case Plain: {
                        msg = session.createMessage();
                        break;
                    }
                    default: {
                        msg = session.createObjectMessage();
                    }
                }
                producer.send(((JMSBindingData)this._composer.decompose(exchange, (BindingData)new JMSBindingData((javax.jms.Message)msg))).getMessage(), this.getDeliveryModeFromContext(context, producer), this.getPriorityFromContext(context, producer), this.getTimeToLiveFromContext(context, producer));
                if (session.getTransacted()) {
                    try {
                        session.commit();
                    }
                    catch (Exception e) {
                        if (!this._logger.isDebugEnabled()) break block24;
                        e.printStackTrace();
                    }
                }
            }
            Message message = null;
            return message;
        }
        catch (Exception e) {
            block25: {
                try {
                    if (session != null && session.getTransacted()) {
                        session.rollback();
                    }
                }
                catch (Exception e2) {
                    if (!this._logger.isDebugEnabled()) break block25;
                    e2.printStackTrace();
                }
            }
            throw JCAMessages.MESSAGES.failedToProcessJMSOutboundInteraction(e);
        }
        finally {
            block26: {
                try {
                    if (session != null) {
                        session.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (JMSException e) {
                    JCALogger.ROOT_LOGGER.failedToCloseJMSSessionconnection(e.getMessage());
                    if (!this._logger.isDebugEnabled()) break block26;
                    e.printStackTrace();
                }
            }
        }
    }

    protected boolean getTxEnabledFromContext(Context ctx) {
        String key = "org.switchyard.component.jca.processor.transacted";
        if (ctx.getProperty(key) != null) {
            boolean transacted = Boolean.parseBoolean(ctx.getPropertyValue(key).toString());
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)("transacted is set to '" + transacted + "'"));
            }
            return transacted;
        }
        return this._defaultTxEnabled;
    }

    protected int getAcknowledgeModeFromContext(Context ctx) {
        String key = "org.switchyard.component.jca.processor.acknowledgeMode";
        if (ctx.getProperty(key) != null) {
            int ackMode = Integer.parseInt(ctx.getPropertyValue(key).toString());
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)("Acknowledge Mode is set to '" + ackMode + "'"));
            }
            return ackMode;
        }
        return this._defaultAckMode;
    }

    protected Destination getDestinationFromContext(Session session, Context ctx) throws Exception {
        Destination destination;
        block15: {
            destination = null;
            String key = "org.switchyard.component.jca.processor.destination";
            if (ctx.getProperty(key) != null) {
                String destName = (String)ctx.getPropertyValue(key);
                DestinationType destType = this.getDestinationTypeFromContext(ctx);
                try {
                    switch (destType) {
                        case JNDI: {
                            destination = this.lookupDestinationFromJNDI(destName);
                            break;
                        }
                        case Queue: {
                            destination = session.createQueue(destName);
                            break;
                        }
                        case Topic: {
                            destination = session.createTopic(destName);
                        }
                    }
                    if (this._logger.isDebugEnabled()) {
                        this._logger.debug((Object)("Destination is set to '" + destName + "'"));
                    }
                }
                catch (Exception e) {
                    JCALogger.ROOT_LOGGER.contextDestinationNotFound(destName, this._defaultDestination);
                    if (!this._logger.isDebugEnabled()) break block15;
                    this._logger.debug((Object)e);
                }
            }
        }
        if (destination == null) {
            switch (this._defaultDestinationType) {
                case JNDI: {
                    destination = this._defaultJmsDestination;
                    break;
                }
                case Queue: {
                    destination = session.createQueue(this._defaultDestination);
                    break;
                }
                case Topic: {
                    destination = session.createTopic(this._defaultDestination);
                }
            }
        }
        return destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Destination lookupDestinationFromJNDI(String destName) throws Exception {
        InitialContext ic = null;
        try {
            ic = this.getDestinationJndiProperties() != null ? new InitialContext(this.getDestinationJndiProperties()) : (this.getJndiProperties() != null ? new InitialContext(this.getJndiProperties()) : new InitialContext());
            Destination destination = (Destination)ic.lookup(destName);
            return destination;
        }
        finally {
            block8: {
                if (ic != null) {
                    try {
                        ic.close();
                    }
                    catch (Exception e) {
                        if (!this._logger.isDebugEnabled()) break block8;
                        this._logger.debug((Object)e);
                    }
                }
            }
        }
    }

    protected DestinationType getDestinationTypeFromContext(Context ctx) {
        String type;
        DestinationType ctxType;
        DestinationType destType = this._defaultDestinationType;
        String key = "org.switchyard.component.jca.processor.destinationType";
        if (ctx.getProperty(key) != null && (ctxType = this.parseDestinationType(type = (String)ctx.getPropertyValue(key))) != null) {
            destType = ctxType;
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)("Destination type is set to '" + destType.toString() + "'"));
            }
        }
        return destType;
    }

    protected MessageType getOutputMessageTypeFromContext(Context ctx) {
        String key = "org.switchyard.component.jca.processor.messageType";
        if (ctx.getProperty(key) != null) {
            MessageType msgType = MessageType.valueOf(ctx.getPropertyValue(key).toString());
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)("Output message type is set to '" + msgType.toString() + "'"));
            }
            return msgType;
        }
        return this._defaultOutMessageType;
    }

    protected int getDeliveryModeFromContext(Context ctx, MessageProducer producer) throws JMSException {
        String key = "org.switchyard.component.jca.processor.deliveryMode";
        if (ctx.getProperty(key) != null) {
            int deliveryMode = Integer.parseInt(ctx.getPropertyValue(key).toString());
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)("Delivery Mode is set to '" + deliveryMode + "'"));
            }
            return deliveryMode;
        }
        return producer.getDeliveryMode();
    }

    protected int getPriorityFromContext(Context ctx, MessageProducer producer) throws JMSException {
        String key = "org.switchyard.component.jca.processor.priority";
        if (ctx.getProperty(key) != null) {
            int priority = Integer.parseInt(ctx.getPropertyValue(key).toString());
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)("Priority is set to '" + priority + "'"));
            }
            return priority;
        }
        return producer.getPriority();
    }

    protected long getTimeToLiveFromContext(Context ctx, MessageProducer producer) throws JMSException {
        String key = "org.switchyard.component.jca.processor.timeToLive";
        if (ctx.getProperty(key) != null) {
            long ttl = Long.parseLong(ctx.getPropertyValue(key).toString());
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)("Time to Live is set to '" + ttl + "'"));
            }
            return ttl;
        }
        return producer.getTimeToLive();
    }

    public void setDestinationType(String type) {
        DestinationType destType = this.parseDestinationType(type);
        if (destType == null) {
            JCALogger.ROOT_LOGGER.invalidDestinationType(type, DestinationType.JNDI.toString());
            destType = DestinationType.JNDI;
        }
        this._defaultDestinationType = destType;
    }

    protected DestinationType parseDestinationType(String type) {
        DestinationType destType = null;
        if (type.equals(Queue.class.getName()) || type.equalsIgnoreCase("queue")) {
            destType = DestinationType.Queue;
        } else if (type.equals(Topic.class.getName()) || type.equalsIgnoreCase("Topic")) {
            destType = DestinationType.Topic;
        } else if (type.equalsIgnoreCase("JNDI")) {
            destType = DestinationType.JNDI;
        }
        return destType;
    }

    public void setDestination(String name) {
        this._defaultDestination = name;
    }

    public void setUsername(String user) {
        this._userName = user;
    }

    public void setPassword(String passwd) {
        this._password = passwd;
    }

    public void setTransacted(String tx) {
        this._transacted = tx;
    }

    public void setAcknowledgeMode(String ack) {
        this._acknowledgeMode = ack;
    }

    public void setMessageType(String type) {
        this._defaultOutMessageType = MessageType.valueOf(type);
    }

    public void setDestinationJndiPropertiesFileName(String name) {
        this._destinationJndiPropertiesFileName = name;
    }

    public Properties getDestinationJndiProperties() {
        if (this._destinationJndiPropertiesFileName != null && this._destinationJndiProperties == null) {
            try {
                InputStream is = Classes.getResourceAsStream((String)this._destinationJndiPropertiesFileName);
                Properties props = new Properties();
                props.load(is);
                is.close();
                this._destinationJndiProperties = props;
            }
            catch (Exception e) {
                JCALogger.ROOT_LOGGER.failedToLoadJndiPropertiesFile(this._destinationJndiPropertiesFileName, e);
            }
        }
        return this._destinationJndiProperties;
    }

    private static enum MessageType {
        Stream,
        Map,
        Text,
        Object,
        Bytes,
        Plain;

    }

    private static enum DestinationType {
        Queue,
        Topic,
        JNDI;

    }
}

