/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.decoders;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.milyn.javabean.DataDecodeException;
import org.milyn.javabean.DataDecoder;
import org.milyn.javabean.DecodeType;

@DecodeType(value={String.class})
public class BinaryDecoder
implements DataDecoder {
    private static final Pattern BINARY_PATTERN = Pattern.compile("^[01]+$");

    public Object decode(String data) throws DataDecodeException {
        Matcher binaryMatcher = BINARY_PATTERN.matcher(data);
        if (binaryMatcher.matches()) {
            return data;
        }
        throw new DataDecodeException("Failed to decode binary sequence '" + data + "'.");
    }
}

